/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ServiceAssemblyStatisticsData;
import com.sun.esb.management.common.data.ServiceUnitStatisticsData;
import com.sun.esb.management.common.data.helper.ServiceAssemblyStatisticsDataReader;
import com.sun.esb.management.common.data.helper.ServiceAssemblyStatisticsDataXMLConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ServiceAssemblyStatisticsDataWriter
implements ServiceAssemblyStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    static final String FILE_NAME_KEY = "ServiceAssemblyStatisticsData.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(Map<String, ServiceAssemblyStatisticsData> dataMap) throws ParserConfigurationException, TransformerException {
        Document document = null;
        ServiceAssemblyStatisticsDataWriter writer = new ServiceAssemblyStatisticsDataWriter();
        if (dataMap != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("ServiceAssemblyStatisticsDataList");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/ServiceAssemblyStatisticsDataList");
            root.setAttribute("version", "1.0");
            for (String instanceName : dataMap.keySet()) {
                ServiceAssemblyStatisticsData data = dataMap.get(instanceName);
                Element serviceAssemblyStatisticsDataElementChild = writer.createServiceAssemblyStatisticsDataElement(document, data);
                root.appendChild(serviceAssemblyStatisticsDataElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected Element createServiceAssemblyStatisticsDataElement(Document document, ServiceAssemblyStatisticsData data) {
        Element serviceAssemblyStatisticsDataElement = null;
        if (document != null && data != null) {
            serviceAssemblyStatisticsDataElement = document.createElement("ServiceAssemblyStatisticsData");
            Element instanceNameElementChild = document.createElement("InstanceName");
            if (instanceNameElementChild != null) {
                instanceNameElementChild.setTextContent(data.getInstanceName());
            }
            serviceAssemblyStatisticsDataElement.appendChild(instanceNameElementChild);
            Element serviceAssemblyElementChild = document.createElement("ServiceAssemblyName");
            if (serviceAssemblyElementChild != null) {
                serviceAssemblyElementChild.setTextContent(data.getName());
            }
            serviceAssemblyStatisticsDataElement.appendChild(serviceAssemblyElementChild);
            Element serviceAssemblyLastStartupElementChild = document.createElement("ServiceAssemblyLastStartupTime");
            if (serviceAssemblyLastStartupElementChild != null) {
                serviceAssemblyLastStartupElementChild.setTextContent(data.getLastStartupTime() + "");
            }
            serviceAssemblyStatisticsDataElement.appendChild(serviceAssemblyLastStartupElementChild);
            Element serviceAssemblyStartupTimeAverageElementChild = document.createElement("ServiceAssemblyStartupTimeAverage");
            if (serviceAssemblyStartupTimeAverageElementChild != null) {
                serviceAssemblyStartupTimeAverageElementChild.setTextContent(data.getStartupTimeAverage() + "");
            }
            serviceAssemblyStatisticsDataElement.appendChild(serviceAssemblyStartupTimeAverageElementChild);
            Element serviceAssemblyShutdownTimeAverageElementChild = document.createElement("ServiceAssemblyShutdownTimeAverage");
            if (serviceAssemblyShutdownTimeAverageElementChild != null) {
                serviceAssemblyShutdownTimeAverageElementChild.setTextContent(data.getShutdownTimeAverage() + "");
            }
            serviceAssemblyStatisticsDataElement.appendChild(serviceAssemblyShutdownTimeAverageElementChild);
            Element serviceAssemblyStopTimeAverageElementChild = document.createElement("ServiceAssemblyStopTimeAverage");
            if (serviceAssemblyStopTimeAverageElementChild != null) {
                serviceAssemblyStopTimeAverageElementChild.setTextContent(data.getStopTimeAverage() + "");
            }
            serviceAssemblyStatisticsDataElement.appendChild(serviceAssemblyStopTimeAverageElementChild);
            Element serviceAssemblyUpTimeElementChild = document.createElement("ServiceAssemblyUpTime");
            if (serviceAssemblyUpTimeElementChild != null) {
                serviceAssemblyUpTimeElementChild.setTextContent(data.getUpTime() + "");
            }
            serviceAssemblyStatisticsDataElement.appendChild(serviceAssemblyUpTimeElementChild);
            Element serviceUnitStatisticsDataListElementChild = this.createServiceUnitStatisticsDataListElement(document, data.getServiceUnitStatisticsList());
            serviceAssemblyStatisticsDataElement.appendChild(serviceUnitStatisticsDataListElementChild);
        }
        return serviceAssemblyStatisticsDataElement;
    }

    Element createServiceUnitStatisticsDataListElement(Document document, List<ServiceUnitStatisticsData> list) {
        Element serviceUnitStatisticsDataListElement = null;
        if (document != null && list != null) {
            serviceUnitStatisticsDataListElement = document.createElement("ServiceUnitStatisticsDataList");
            serviceUnitStatisticsDataListElement.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/ServiceUnitStatisticsDataList");
            serviceUnitStatisticsDataListElement.setAttribute("version", "1.0");
            for (ServiceUnitStatisticsData data : list) {
                Element serviceUnitDataElementChild = this.createServiceUnitStatisticsDataListElement(document, data);
                serviceUnitStatisticsDataListElement.appendChild(serviceUnitDataElementChild);
            }
        }
        return serviceUnitStatisticsDataListElement;
    }

    Element createServiceUnitStatisticsDataListElement(Document document, ServiceUnitStatisticsData data) {
        Element serviceUnitStatisticsDataElement = null;
        if (document != null && data != null) {
            serviceUnitStatisticsDataElement = document.createElement("ServiceUnitStatisticsData");
            Element serviceUnitElementChild = document.createElement("ServiceUnitName");
            if (serviceUnitElementChild != null) {
                serviceUnitElementChild.setTextContent(data.getName());
            }
            serviceUnitStatisticsDataElement.appendChild(serviceUnitElementChild);
            Element serviceUnitStartupTimeAverageElementChild = document.createElement("ServiceUnitStartupTimeAverage");
            if (serviceUnitStartupTimeAverageElementChild != null) {
                serviceUnitStartupTimeAverageElementChild.setTextContent(data.getStartupTimeAverage() + "");
            }
            serviceUnitStatisticsDataElement.appendChild(serviceUnitStartupTimeAverageElementChild);
            Element serviceUnitShutdownTimeAverageElementChild = document.createElement("ServiceUnitShutdownTimeAverage");
            if (serviceUnitShutdownTimeAverageElementChild != null) {
                serviceUnitShutdownTimeAverageElementChild.setTextContent(data.getShutdownTimeAverage() + "");
            }
            serviceUnitStatisticsDataElement.appendChild(serviceUnitShutdownTimeAverageElementChild);
            Element serviceUnitStopTimeAverageElementChild = document.createElement("ServiceUnitStopTimeAverage");
            if (serviceUnitStopTimeAverageElementChild != null) {
                serviceUnitStopTimeAverageElementChild.setTextContent(data.getStopTimeAverage() + "");
            }
            serviceUnitStatisticsDataElement.appendChild(serviceUnitStopTimeAverageElementChild);
            Element serviceUnitEndpointListElement = document.createElement("EndpointNameList");
            for (String endpointName : data.getEndpointNameList()) {
                Element serviceUnitEndpointNameElement = document.createElement("EndpointName");
                if (serviceUnitEndpointNameElement != null) {
                    serviceUnitEndpointNameElement.setTextContent(endpointName);
                }
                serviceUnitEndpointListElement.appendChild(serviceUnitEndpointNameElement);
            }
            serviceUnitStatisticsDataElement.appendChild(serviceUnitEndpointListElement);
        }
        return serviceUnitStatisticsDataElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/assemblystatistics/ServiceAssemblyStatisticsData.xml";
        try {
            Map<String, ServiceAssemblyStatisticsData> map = null;
            map = ServiceAssemblyStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
            String content = ServiceAssemblyStatisticsDataWriter.serialize(map);
            System.out.println(content);
            ServiceAssemblyStatisticsDataWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

