/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ComponentStatisticsData;
import com.sun.esb.management.common.data.helper.ComponentStatisticsDataXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentStatisticsDataReader
extends DefaultHandler
implements ComponentStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private String componentStatisticsDataListVersion;
    private ComponentStatisticsData data;
    private Map<String, ComponentStatisticsData> dataMap;

    public Map<String, ComponentStatisticsData> getComponentStatisticsDataMap() {
        return this.dataMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("ComponentStatisticsDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.componentStatisticsDataListVersion = attributes.getValue("version");
                    if (this.componentStatisticsDataListVersion != null && "1.0".equals(this.componentStatisticsDataListVersion)) {
                        this.dataMap = new HashMap<String, ComponentStatisticsData>();
                    }
                }
            } else if (qName.endsWith("ComponentStatisticsData") && this.dataMap != null) {
                this.data = new ComponentStatisticsData();
            }
            this.qNameStack.push(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("InstanceName")) {
            if (this.data != null) {
                this.data.setInstanceName(chars);
            }
        } else if (qName.endsWith("ComponentUpTime")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setComponentUpTime(value);
            }
        } else if (qName.endsWith("NumberOfActivatedEndpoints")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfActivatedEndpoints(value);
            }
        } else if (qName.endsWith("NumberOfReceivedRequests")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfReceivedRequests(value);
            }
        } else if (qName.endsWith("NumberOfSentRequests")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfSentRequests(value);
            }
        } else if (qName.endsWith("NumberOfReceivedReplies")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfReceivedReplies(value);
            }
        } else if (qName.endsWith("NumberOfSentReplies")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfSentReplies(value);
            }
        } else if (qName.endsWith("NumberOfReceivedDones")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfReceivedDones(value);
            }
        } else if (qName.endsWith("NumberOfSentDones")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfSentDones(value);
            }
        } else if (qName.endsWith("NumberOfReceivedFaults")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfReceivedFaults(value);
            }
        } else if (qName.endsWith("NumberOfSentFaults")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfSentFaults(value);
            }
        } else if (qName.endsWith("NumberOfReceivedErrors")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfReceivedErrors(value);
            }
        } else if (qName.endsWith("NumberOfSentErrors")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfSentErrors(value);
            }
        } else if (qName.endsWith("NumberOfCompletedExchanges")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfCompletedExchanges(value);
            }
        } else if (qName.endsWith("NumberOfActiveExchanges")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfActiveExchanges(value);
            }
        } else if (qName.endsWith("NumberOfErrorExchanges")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setNumberOfErrorExchanges(value);
            }
        } else if (qName.endsWith("ExtendedTimingStatisticsFlagEnabled")) {
            if (this.data != null) {
                boolean value = Boolean.valueOf(chars);
                this.data.setExtendedTimingStatisticsFlagEnabled(value);
            }
        } else if (qName.endsWith("MessageExchangeResponseTimeAverage")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setMessageExchangeResponseTimeAverage(value);
            }
        } else if (qName.endsWith("MessageExchangeComponentTimeAverage")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setMessageExchangeComponentTimeAverage(value);
            }
        } else if (qName.endsWith("MessageExchangeDeliveryChannelTimeAverage")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setMessageExchangeDeliveryChannelTimeAverage(value);
            }
        } else if (qName.endsWith("MessageExchangeMessageServiceTimeAverage")) {
            if (this.data != null) {
                long value = Long.valueOf(chars);
                this.data.setMessageExchangeMessageServiceTimeAverage(value);
            }
        } else if (qName.endsWith("ComponentExtensionStatus") && this.data != null) {
            this.data.setComponentExtensionStatusAsString(chars);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null && qName.endsWith("ComponentStatisticsData") && this.dataMap != null && this.data != null) {
            this.dataMap.put(this.data.getInstanceName(), this.data);
            this.data = null;
        }
    }

    public static Map<String, ComponentStatisticsData> parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        ComponentStatisticsDataReader parser = new ComponentStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getComponentStatisticsDataMap();
    }

    public static Map<String, ComponentStatisticsData> parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return ComponentStatisticsDataReader.parseFromFile(file);
    }

    public static Map<String, ComponentStatisticsData> parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        ComponentStatisticsDataReader parser = new ComponentStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getComponentStatisticsDataMap();
    }

    public static Map<String, ComponentStatisticsData> parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return ComponentStatisticsDataReader.parseFromURI(uri);
    }

    public static Map<String, ComponentStatisticsData> parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        ComponentStatisticsDataReader parser = new ComponentStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getComponentStatisticsDataMap();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/componentstatistics/ComponentStatisticsData.xml";
        try {
            Map<String, ComponentStatisticsData> map = null;
            map = ComponentStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

