/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ServiceUnitStatisticsData;
import com.sun.esb.management.common.data.helper.ServiceAssemblyStatisticsDataCreator;
import com.sun.esb.management.common.data.helper.ServiceAssemblyStatisticsDataWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class ServiceAssemblyStatisticsData
implements Serializable {
    static final long serialVersionUID = -1L;
    public static final String INSTANCE_NAME_KEY = "InstanceName";
    public static final String NAME_KEY = "ServiceAssemblyName";
    public static final String LAST_STARTUP_TIME_KEY = "LastStartupTime";
    public static final String STARTUP_TIME_AVG_KEY = "StartupTime Avg (ms)";
    public static final String STOP_TIME_AVG_KEY = "StopTime Avg (ms)";
    public static final String SHUTDOWN_TIME_AVG_KEY = "ShutdownTime Avg (ms)";
    public static final String UP_TIME_KEY = "UpTime (ms)";
    public static final String SERVICE_UNIT_STATISTICS_KEY = "ServiceUnitStatistics";
    String instanceName;
    String name;
    Date lastStartupTime;
    long startupTimeAverage;
    long stopTimeAverage;
    long shutdownTimeAverage;
    long upTime;
    List<ServiceUnitStatisticsData> serviceUnitStatisticsList = new ArrayList<ServiceUnitStatisticsData>();

    public static TabularData generateTabularData(Map<String, ServiceAssemblyStatisticsData> map) {
        TabularData tabularData = null;
        try {
            tabularData = ServiceAssemblyStatisticsDataCreator.createTabularData(map);
        }
        catch (ManagementRemoteException managementRemoteException) {
            // empty catch block
        }
        return tabularData;
    }

    public static Map<String, ServiceAssemblyStatisticsData> retrieveDataMap(TabularData tabularData) {
        ServiceAssemblyStatisticsData data = null;
        HashMap<String, ServiceAssemblyStatisticsData> map = null;
        map = new HashMap<String, ServiceAssemblyStatisticsData>();
        for (CompositeData compositeData : tabularData.values()) {
            CompositeType compositeType = compositeData.getCompositeType();
            data = new ServiceAssemblyStatisticsData();
            for (String item : compositeType.keySet()) {
                CompositeData[] values;
                Object value;
                if (item.equals(INSTANCE_NAME_KEY)) {
                    value = (String)compositeData.get(item);
                    data.setInstanceName((String)value);
                }
                if (item.equals(LAST_STARTUP_TIME_KEY)) {
                    value = (Date)compositeData.get(item);
                    data.setLastStartupTime((Date)value);
                }
                if (item.equals(NAME_KEY)) {
                    value = (String)compositeData.get(item);
                    data.setName((String)value);
                }
                if (item.equals(SHUTDOWN_TIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    data.setShutdownTimeAverage((Long)value);
                }
                if (item.equals(STARTUP_TIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null) {
                        data.setStartupTimeAverage((Long)value);
                    }
                }
                if (item.equals(STOP_TIME_AVG_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null) {
                        data.setStopTimeAverage((Long)value);
                    }
                }
                if (item.equals(UP_TIME_KEY)) {
                    value = (Long)compositeData.get(item);
                    if (data != null) {
                        data.setUpTime((Long)value);
                    }
                }
                if (!item.equals(SERVICE_UNIT_STATISTICS_KEY) || (values = (CompositeData[])compositeData.get(item)) == null) continue;
                ServiceUnitStatisticsData unit = null;
                for (CompositeData value2 : values) {
                    CompositeType valueType = value2.getCompositeType();
                    unit = new ServiceUnitStatisticsData();
                    for (String key : valueType.keySet()) {
                        Object datum;
                        if (key.equals("Endpoints")) {
                            datum = (String[])value2.get(key);
                            unit.setEndpointNameList((String[])datum);
                        }
                        if (key.equals("ServiceUnitName")) {
                            datum = (String)value2.get(key);
                            unit.setName((String)datum);
                        }
                        if (key.equals("ServiceUnitShutdownTime Avg (ms)")) {
                            datum = (Long)value2.get(key);
                            unit.setShutdownTimeAverage((Long)datum);
                        }
                        if (key.equals("ServiceUnitStartupTime Avg (ms)")) {
                            datum = (Long)value2.get(key);
                            unit.setStartupTimeAverage((Long)datum);
                        }
                        if (!key.equals("ServiceUnitStopTime Avg (ms)")) continue;
                        datum = (Long)value2.get(key);
                        unit.setStopTimeAverage((Long)datum);
                    }
                    data.getServiceUnitStatisticsList().add(unit);
                }
            }
            map.put(data.getInstanceName(), data);
        }
        return map;
    }

    public static String convertDataMapToXML(Map<String, ServiceAssemblyStatisticsData> map) throws ManagementRemoteException {
        String xmlText = null;
        try {
            xmlText = ServiceAssemblyStatisticsDataWriter.serialize(map);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (TransformerException e) {
            throw new ManagementRemoteException(e);
        }
        return xmlText;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public Date getLastStartupTime() {
        return this.lastStartupTime;
    }

    public void setLastStartupTime(Date lastStartupTime) {
        this.lastStartupTime = lastStartupTime;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String serviceAssemblyName) {
        this.name = serviceAssemblyName;
    }

    public long getStartupTimeAverage() {
        return this.startupTimeAverage;
    }

    public void setStartupTimeAverage(long serviceAssemblyStartTime) {
        this.startupTimeAverage = serviceAssemblyStartTime;
    }

    public long getStopTimeAverage() {
        return this.stopTimeAverage;
    }

    public void setStopTimeAverage(long serviceAssemblyStopTime) {
        this.stopTimeAverage = serviceAssemblyStopTime;
    }

    public long getShutdownTimeAverage() {
        return this.shutdownTimeAverage;
    }

    public void setShutdownTimeAverage(long serviceAssemblyShutdownTime) {
        this.shutdownTimeAverage = serviceAssemblyShutdownTime;
    }

    public List<ServiceUnitStatisticsData> getServiceUnitStatisticsList() {
        return this.serviceUnitStatisticsList;
    }

    public ServiceUnitStatisticsData[] getServiceUnitStatisticsArray() {
        ServiceUnitStatisticsData[] result = null;
        result = ServiceAssemblyStatisticsData.toArray(this.serviceUnitStatisticsList, ServiceUnitStatisticsData.class);
        return result;
    }

    public void setServiceUnitStatisticsList(List<ServiceUnitStatisticsData> serviceUnitStatisticsList) {
        this.serviceUnitStatisticsList = serviceUnitStatisticsList;
    }

    public void setServiceUnitStatisticsList(ServiceUnitStatisticsData[] serviceUnitStatisticsArray) {
        for (ServiceUnitStatisticsData unitData : serviceUnitStatisticsArray) {
            this.serviceUnitStatisticsList.add(unitData);
        }
    }

    protected static <Type> Type[] toArray(Collection<Type> collection, Class<Type> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, collection.size());
        int index = 0;
        for (Type value : collection) {
            array[index++] = value;
        }
        return array;
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n  Instance Name=" + this.getInstanceName());
        buffer.append("\n  Service Assembly Name=" + this.getName());
        buffer.append("\n  Service Assembly Last Startup Time=" + this.getLastStartupTime());
        buffer.append("\n  Service Assembly Shutdown Time Average=" + this.getShutdownTimeAverage());
        buffer.append("\n  Service Assembly Start Time Average=" + this.getStartupTimeAverage());
        buffer.append("\n  Service Assembly Stop Time Average=" + this.getStopTimeAverage());
        buffer.append("\n  Service Assembly Up Time=" + this.getUpTime());
        if (this.getServiceUnitStatisticsList() != null && this.getServiceUnitStatisticsList().size() > 0) {
            buffer.append("\n  Service Unit Statistics List:");
            for (ServiceUnitStatisticsData data : this.getServiceUnitStatisticsList()) {
                buffer.append(data.getDisplayString());
            }
        }
        buffer.append("\n  ========================================\n");
        return buffer.toString();
    }

    public static void main(String[] args) {
    }
}

