/*
 * Decompiled with CFR 0.152.
 */
package net.opacapp.multilinecollapsingtoolbar;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.math.MathUtils;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Interpolator;
import net.opacapp.multilinecollapsingtoolbar.AnimationUtils;

final class CollapsingTextHelper {
    private static final boolean USE_SCALING_TEXTURE = Build.VERSION.SDK_INT < 18;
    private static final boolean DEBUG_DRAW = false;
    private static final Paint DEBUG_DRAW_PAINT = null;
    private final View mView;
    private boolean mDrawTitle;
    private float mExpandedFraction;
    private final Rect mExpandedBounds;
    private final Rect mCollapsedBounds;
    private final RectF mCurrentBounds;
    private int mExpandedTextGravity = 16;
    private int mCollapsedTextGravity = 16;
    private float mExpandedTextSize = 15.0f;
    private float mCollapsedTextSize = 15.0f;
    private ColorStateList mExpandedTextColor;
    private ColorStateList mCollapsedTextColor;
    private float mExpandedDrawY;
    private float mCollapsedDrawY;
    private float mExpandedDrawX;
    private float mCollapsedDrawX;
    private float mCurrentDrawX;
    private float mCurrentDrawY;
    private Typeface mCollapsedTypeface;
    private Typeface mExpandedTypeface;
    private Typeface mCurrentTypeface;
    private CharSequence mText;
    private CharSequence mTextToDraw;
    private boolean mIsRtl;
    private boolean mUseTexture;
    private Bitmap mExpandedTitleTexture;
    private Paint mTexturePaint;
    private float mScale;
    private float mCurrentTextSize;
    private int[] mState;
    private boolean mBoundsChanged;
    private final TextPaint mTextPaint;
    private Interpolator mPositionInterpolator;
    private Interpolator mTextSizeInterpolator;
    private float mCollapsedShadowRadius;
    private float mCollapsedShadowDx;
    private float mCollapsedShadowDy;
    private int mCollapsedShadowColor;
    private float mExpandedShadowRadius;
    private float mExpandedShadowDx;
    private float mExpandedShadowDy;
    private int mExpandedShadowColor;
    private CharSequence mTextToDrawCollapsed;
    private Bitmap mCollapsedTitleTexture;
    private Bitmap mCrossSectionTitleTexture;
    private StaticLayout mTextLayout;
    private float mCollapsedTextBlend;
    private float mExpandedTextBlend;
    private float mExpandedFirstLineDrawX;
    private int maxLines = 3;
    private float lineSpacingExtra = 0.0f;
    private float lineSpacingMultiplier = 1.0f;

    public CollapsingTextHelper(View view) {
        this.mView = view;
        this.mTextPaint = new TextPaint(129);
        this.mCollapsedBounds = new Rect();
        this.mExpandedBounds = new Rect();
        this.mCurrentBounds = new RectF();
    }

    void setTextSizeInterpolator(Interpolator interpolator) {
        this.mTextSizeInterpolator = interpolator;
        this.recalculate();
    }

    void setPositionInterpolator(Interpolator interpolator) {
        this.mPositionInterpolator = interpolator;
        this.recalculate();
    }

    void setExpandedTextSize(float textSize) {
        if (this.mExpandedTextSize != textSize) {
            this.mExpandedTextSize = textSize;
            this.recalculate();
        }
    }

    void setCollapsedTextSize(float textSize) {
        if (this.mCollapsedTextSize != textSize) {
            this.mCollapsedTextSize = textSize;
            this.recalculate();
        }
    }

    void setCollapsedTextColor(ColorStateList textColor) {
        if (this.mCollapsedTextColor != textColor) {
            this.mCollapsedTextColor = textColor;
            this.recalculate();
        }
    }

    void setExpandedTextColor(ColorStateList textColor) {
        if (this.mExpandedTextColor != textColor) {
            this.mExpandedTextColor = textColor;
            this.recalculate();
        }
    }

    void setExpandedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper.rectEquals(this.mExpandedBounds, left, top, right, bottom)) {
            this.mExpandedBounds.set(left, top, right, bottom);
            this.mBoundsChanged = true;
            this.onBoundsChanged();
        }
    }

    void setCollapsedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingTextHelper.rectEquals(this.mCollapsedBounds, left, top, right, bottom)) {
            this.mCollapsedBounds.set(left, top, right, bottom);
            this.mBoundsChanged = true;
            this.onBoundsChanged();
        }
    }

    void onBoundsChanged() {
        this.mDrawTitle = this.mCollapsedBounds.width() > 0 && this.mCollapsedBounds.height() > 0 && this.mExpandedBounds.width() > 0 && this.mExpandedBounds.height() > 0;
    }

    void setExpandedTextGravity(int gravity) {
        if (this.mExpandedTextGravity != gravity) {
            this.mExpandedTextGravity = gravity;
            this.recalculate();
        }
    }

    int getExpandedTextGravity() {
        return this.mExpandedTextGravity;
    }

    void setCollapsedTextGravity(int gravity) {
        if (this.mCollapsedTextGravity != gravity) {
            this.mCollapsedTextGravity = gravity;
            this.recalculate();
        }
    }

    int getCollapsedTextGravity() {
        return this.mCollapsedTextGravity;
    }

    void setCollapsedTextAppearance(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, R.styleable.TextAppearance);
        if (a.hasValue(R.styleable.TextAppearance_android_textColor)) {
            this.mCollapsedTextColor = a.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        if (a.hasValue(R.styleable.TextAppearance_android_textSize)) {
            this.mCollapsedTextSize = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, (int)this.mCollapsedTextSize);
        }
        this.mCollapsedShadowColor = a.getInt(R.styleable.TextAppearance_android_shadowColor, 0);
        this.mCollapsedShadowDx = a.getFloat(R.styleable.TextAppearance_android_shadowDx, 0.0f);
        this.mCollapsedShadowDy = a.getFloat(R.styleable.TextAppearance_android_shadowDy, 0.0f);
        this.mCollapsedShadowRadius = a.getFloat(R.styleable.TextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.mCollapsedTypeface = this.readFontFamilyTypeface(resId);
        }
        this.recalculate();
    }

    void setExpandedTextAppearance(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, R.styleable.TextAppearance);
        if (a.hasValue(R.styleable.TextAppearance_android_textColor)) {
            this.mExpandedTextColor = a.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        if (a.hasValue(R.styleable.TextAppearance_android_textSize)) {
            this.mExpandedTextSize = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, (int)this.mExpandedTextSize);
        }
        this.mExpandedShadowColor = a.getInt(R.styleable.TextAppearance_android_shadowColor, 0);
        this.mExpandedShadowDx = a.getFloat(R.styleable.TextAppearance_android_shadowDx, 0.0f);
        this.mExpandedShadowDy = a.getFloat(R.styleable.TextAppearance_android_shadowDy, 0.0f);
        this.mExpandedShadowRadius = a.getFloat(R.styleable.TextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.mExpandedTypeface = this.readFontFamilyTypeface(resId);
        }
        this.recalculate();
    }

    void setMaxLines(int maxLines) {
        if (maxLines != this.maxLines) {
            this.maxLines = maxLines;
            this.clearTexture();
            this.recalculate();
        }
    }

    int getMaxLines() {
        return this.maxLines;
    }

    void setLineSpacingExtra(float lineSpacingExtra) {
        if (lineSpacingExtra != this.lineSpacingExtra) {
            this.lineSpacingExtra = lineSpacingExtra;
            this.clearTexture();
            this.recalculate();
        }
    }

    float getLineSpacingExtra() {
        return this.lineSpacingExtra;
    }

    void setLineSpacingMultiplier(float lineSpacingMultiplier) {
        if (lineSpacingMultiplier != this.lineSpacingMultiplier) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            this.clearTexture();
            this.recalculate();
        }
    }

    float getLineSpacingMultiplier() {
        return this.lineSpacingMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Typeface readFontFamilyTypeface(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, new int[]{16843692});
        try {
            String family = a.getString(0);
            if (family != null) {
                Typeface typeface = Typeface.create((String)family, (int)0);
                return typeface;
            }
        }
        finally {
            a.recycle();
        }
        return null;
    }

    void setCollapsedTypeface(Typeface typeface) {
        if (this.areTypefacesDifferent(this.mCollapsedTypeface, typeface)) {
            this.mCollapsedTypeface = typeface;
            this.recalculate();
        }
    }

    void setExpandedTypeface(Typeface typeface) {
        if (this.areTypefacesDifferent(this.mExpandedTypeface, typeface)) {
            this.mExpandedTypeface = typeface;
            this.recalculate();
        }
    }

    void setTypefaces(Typeface typeface) {
        this.mCollapsedTypeface = this.mExpandedTypeface = typeface;
        this.recalculate();
    }

    Typeface getCollapsedTypeface() {
        return this.mCollapsedTypeface != null ? this.mCollapsedTypeface : Typeface.DEFAULT;
    }

    Typeface getExpandedTypeface() {
        return this.mExpandedTypeface != null ? this.mExpandedTypeface : Typeface.DEFAULT;
    }

    void setExpansionFraction(float fraction) {
        if ((fraction = MathUtils.clamp((float)fraction, (float)0.0f, (float)1.0f)) != this.mExpandedFraction) {
            this.mExpandedFraction = fraction;
            this.calculateCurrentOffsets();
        }
    }

    final boolean setState(int[] state) {
        this.mState = state;
        if (this.isStateful()) {
            this.recalculate();
            return true;
        }
        return false;
    }

    final boolean isStateful() {
        return this.mCollapsedTextColor != null && this.mCollapsedTextColor.isStateful() || this.mExpandedTextColor != null && this.mExpandedTextColor.isStateful();
    }

    float getExpansionFraction() {
        return this.mExpandedFraction;
    }

    float getCollapsedTextSize() {
        return this.mCollapsedTextSize;
    }

    float getExpandedTextSize() {
        return this.mExpandedTextSize;
    }

    private void calculateCurrentOffsets() {
        this.calculateOffsets(this.mExpandedFraction);
    }

    private void calculateOffsets(float fraction) {
        this.interpolateBounds(fraction);
        this.mCurrentDrawX = CollapsingTextHelper.lerp(this.mExpandedDrawX, this.mCollapsedDrawX, fraction, this.mPositionInterpolator);
        this.mCurrentDrawY = CollapsingTextHelper.lerp(this.mExpandedDrawY, this.mCollapsedDrawY, fraction, this.mPositionInterpolator);
        this.setInterpolatedTextSize(CollapsingTextHelper.lerp(this.mExpandedTextSize, this.mCollapsedTextSize, fraction, this.mTextSizeInterpolator));
        this.setCollapsedTextBlend(1.0f - CollapsingTextHelper.lerp(0.0f, 1.0f, 1.0f - fraction, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        this.setExpandedTextBlend(CollapsingTextHelper.lerp(1.0f, 0.0f, fraction, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
        if (this.mCollapsedTextColor != this.mExpandedTextColor) {
            this.mTextPaint.setColor(CollapsingTextHelper.blendColors(this.getCurrentExpandedTextColor(), this.getCurrentCollapsedTextColor(), fraction));
        } else {
            this.mTextPaint.setColor(this.getCurrentCollapsedTextColor());
        }
        this.mTextPaint.setShadowLayer(CollapsingTextHelper.lerp(this.mExpandedShadowRadius, this.mCollapsedShadowRadius, fraction, null), CollapsingTextHelper.lerp(this.mExpandedShadowDx, this.mCollapsedShadowDx, fraction, null), CollapsingTextHelper.lerp(this.mExpandedShadowDy, this.mCollapsedShadowDy, fraction, null), CollapsingTextHelper.blendColors(this.mExpandedShadowColor, this.mCollapsedShadowColor, fraction));
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    @ColorInt
    private int getCurrentExpandedTextColor() {
        if (this.mState != null) {
            return this.mExpandedTextColor.getColorForState(this.mState, 0);
        }
        return this.mExpandedTextColor.getDefaultColor();
    }

    @ColorInt
    private int getCurrentCollapsedTextColor() {
        if (this.mState != null) {
            return this.mCollapsedTextColor.getColorForState(this.mState, 0);
        }
        return this.mCollapsedTextColor.getDefaultColor();
    }

    private void calculateBaseOffsets() {
        float currentTextSize = this.mCurrentTextSize;
        this.calculateUsingTextSize(this.mCollapsedTextSize);
        this.mTextToDrawCollapsed = this.mTextToDraw;
        float width = this.mTextToDrawCollapsed != null ? this.mTextPaint.measureText(this.mTextToDrawCollapsed, 0, this.mTextToDrawCollapsed.length()) : 0.0f;
        int collapsedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.mCollapsedTextGravity, (int)(this.mIsRtl ? 1 : 0));
        float textHeight = this.mTextLayout != null ? (float)this.mTextLayout.getHeight() : 0.0f;
        switch (collapsedAbsGravity & 0x70) {
            case 80: {
                this.mCollapsedDrawY = (float)this.mCollapsedBounds.bottom - textHeight;
                break;
            }
            case 48: {
                this.mCollapsedDrawY = this.mCollapsedBounds.top;
                break;
            }
            default: {
                float textOffset = textHeight / 2.0f;
                this.mCollapsedDrawY = (float)this.mCollapsedBounds.centerY() - textOffset;
            }
        }
        switch (collapsedAbsGravity & 0x800007) {
            case 1: {
                this.mCollapsedDrawX = (float)this.mCollapsedBounds.centerX() - width / 2.0f;
                break;
            }
            case 5: {
                this.mCollapsedDrawX = (float)this.mCollapsedBounds.right - width;
                break;
            }
            default: {
                this.mCollapsedDrawX = this.mCollapsedBounds.left;
            }
        }
        this.calculateUsingTextSize(this.mExpandedTextSize);
        width = this.mTextLayout != null ? this.mTextLayout.getLineWidth(0) : 0.0f;
        this.mExpandedFirstLineDrawX = this.mTextLayout != null ? this.mTextLayout.getLineLeft(0) : 0.0f;
        int expandedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.mExpandedTextGravity, (int)(this.mIsRtl ? 1 : 0));
        textHeight = this.mTextLayout != null ? (float)this.mTextLayout.getHeight() : 0.0f;
        switch (expandedAbsGravity & 0x70) {
            case 80: {
                this.mExpandedDrawY = (float)this.mExpandedBounds.bottom - textHeight;
                break;
            }
            case 48: {
                this.mExpandedDrawY = this.mExpandedBounds.top;
                break;
            }
            default: {
                float textOffset = textHeight / 2.0f;
                this.mExpandedDrawY = (float)this.mExpandedBounds.centerY() - textOffset;
            }
        }
        switch (expandedAbsGravity & 0x800007) {
            case 1: {
                this.mExpandedDrawX = (float)this.mExpandedBounds.centerX() - width / 2.0f;
                break;
            }
            case 5: {
                this.mExpandedDrawX = (float)this.mExpandedBounds.right - width;
                break;
            }
            default: {
                this.mExpandedDrawX = this.mExpandedBounds.left;
            }
        }
        this.clearTexture();
        this.setInterpolatedTextSize(currentTextSize);
    }

    private void interpolateBounds(float fraction) {
        this.mCurrentBounds.left = CollapsingTextHelper.lerp(this.mExpandedBounds.left, this.mCollapsedBounds.left, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.top = CollapsingTextHelper.lerp(this.mExpandedDrawY, this.mCollapsedDrawY, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.right = CollapsingTextHelper.lerp(this.mExpandedBounds.right, this.mCollapsedBounds.right, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.bottom = CollapsingTextHelper.lerp(this.mExpandedBounds.bottom, this.mCollapsedBounds.bottom, fraction, this.mPositionInterpolator);
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        if (this.mTextToDraw != null && this.mDrawTitle) {
            float x = this.mCurrentDrawX;
            float y = this.mCurrentDrawY;
            boolean drawTexture = this.mUseTexture && this.mExpandedTitleTexture != null;
            this.mTextPaint.setTextSize(this.mCurrentTextSize);
            float ascent = drawTexture ? 0.0f : this.mTextPaint.ascent() * this.mScale;
            if (this.mScale != 1.0f) {
                canvas.scale(this.mScale, this.mScale, x, y);
            }
            float currentExpandedX = this.mCurrentDrawX + this.mTextLayout.getLineLeft(0) - this.mExpandedFirstLineDrawX * 2.0f;
            if (drawTexture) {
                this.mTexturePaint.setAlpha((int)(this.mExpandedTextBlend * 255.0f));
                canvas.drawBitmap(this.mExpandedTitleTexture, currentExpandedX, y, this.mTexturePaint);
                this.mTexturePaint.setAlpha((int)(this.mCollapsedTextBlend * 255.0f));
                canvas.drawBitmap(this.mCollapsedTitleTexture, x, y, this.mTexturePaint);
                this.mTexturePaint.setAlpha(255);
                canvas.drawBitmap(this.mCrossSectionTitleTexture, x, y, this.mTexturePaint);
            } else {
                canvas.translate(currentExpandedX, y);
                this.mTextPaint.setAlpha((int)(this.mExpandedTextBlend * 255.0f));
                this.mTextLayout.draw(canvas);
                canvas.translate(x - currentExpandedX, 0.0f);
                this.mTextPaint.setAlpha((int)(this.mCollapsedTextBlend * 255.0f));
                canvas.drawText(this.mTextToDrawCollapsed, 0, this.mTextToDrawCollapsed.length(), 0.0f, -ascent / this.mScale, (Paint)this.mTextPaint);
                String tmp = this.mTextToDrawCollapsed.toString().trim();
                if (tmp.endsWith("\u2026")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                this.mTextPaint.setAlpha(255);
                canvas.drawText(tmp, 0, this.mTextLayout.getLineEnd(0) <= tmp.length() ? this.mTextLayout.getLineEnd(0) : tmp.length(), 0.0f, -ascent / this.mScale, (Paint)this.mTextPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private boolean calculateIsRtl(CharSequence text) {
        boolean defaultIsRtl = ViewCompat.getLayoutDirection((View)this.mView) == 1;
        return (defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR).isRtl(text, 0, text.length());
    }

    private void setInterpolatedTextSize(float textSize) {
        this.calculateUsingTextSize(textSize);
        boolean bl = this.mUseTexture = USE_SCALING_TEXTURE && this.mScale != 1.0f;
        if (this.mUseTexture) {
            this.ensureExpandedTexture();
            this.ensureCollapsedTexture();
            this.ensureCrossSectionTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private void setCollapsedTextBlend(float blend) {
        this.mCollapsedTextBlend = blend;
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private void setExpandedTextBlend(float blend) {
        this.mExpandedTextBlend = blend;
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private boolean areTypefacesDifferent(Typeface first, Typeface second) {
        return first != null && !first.equals((Object)second) || first == null && second != null;
    }

    private void calculateUsingTextSize(float textSize) {
        int maxLines;
        float availableWidth;
        float newTextSize;
        if (this.mText == null) {
            return;
        }
        float collapsedWidth = this.mCollapsedBounds.width();
        float expandedWidth = this.mExpandedBounds.width();
        boolean updateDrawText = false;
        if (CollapsingTextHelper.isClose(textSize, this.mCollapsedTextSize)) {
            newTextSize = this.mCollapsedTextSize;
            this.mScale = 1.0f;
            if (this.areTypefacesDifferent(this.mCurrentTypeface, this.mCollapsedTypeface)) {
                this.mCurrentTypeface = this.mCollapsedTypeface;
                updateDrawText = true;
            }
            availableWidth = collapsedWidth;
            maxLines = 1;
        } else {
            newTextSize = this.mExpandedTextSize;
            if (this.areTypefacesDifferent(this.mCurrentTypeface, this.mExpandedTypeface)) {
                this.mCurrentTypeface = this.mExpandedTypeface;
                updateDrawText = true;
            }
            this.mScale = CollapsingTextHelper.isClose(textSize, this.mExpandedTextSize) ? 1.0f : textSize / this.mExpandedTextSize;
            float textSizeRatio = this.mCollapsedTextSize / this.mExpandedTextSize;
            float scaledDownWidth = expandedWidth * textSizeRatio;
            availableWidth = scaledDownWidth > collapsedWidth ? expandedWidth : expandedWidth;
            maxLines = this.maxLines;
        }
        if (availableWidth > 0.0f) {
            updateDrawText = this.mCurrentTextSize != newTextSize || this.mBoundsChanged || updateDrawText;
            this.mCurrentTextSize = newTextSize;
            this.mBoundsChanged = false;
        }
        if (this.mTextToDraw == null || updateDrawText) {
            Layout.Alignment alignment;
            CharSequence truncatedText;
            this.mTextPaint.setTextSize(this.mCurrentTextSize);
            this.mTextPaint.setTypeface(this.mCurrentTypeface);
            StaticLayout layout = new StaticLayout(this.mText, this.mTextPaint, (int)availableWidth, Layout.Alignment.ALIGN_NORMAL, this.lineSpacingMultiplier, this.lineSpacingExtra, false);
            if (layout.getLineCount() > maxLines) {
                int lastLine = maxLines - 1;
                String textBefore = lastLine > 0 ? this.mText.subSequence(0, layout.getLineEnd(lastLine - 1)) : "";
                CharSequence lineText = this.mText.subSequence(layout.getLineStart(lastLine), layout.getLineEnd(lastLine));
                CharSequence lineEnd = "";
                if (lineText.charAt(lineText.length() - 1) == ' ') {
                    lineEnd = lineText.subSequence(lineText.length() - 1, lineText.length());
                    lineText = lineText.subSequence(0, lineText.length() - 1);
                }
                lineText = TextUtils.concat((CharSequence[])new CharSequence[]{lineText, "\u2026", lineEnd});
                CharSequence truncatedLineText = TextUtils.ellipsize((CharSequence)lineText, (TextPaint)this.mTextPaint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                truncatedText = TextUtils.concat((CharSequence[])new CharSequence[]{textBefore, truncatedLineText});
            } else {
                truncatedText = this.mText;
            }
            if (!TextUtils.equals((CharSequence)truncatedText, (CharSequence)this.mTextToDraw)) {
                this.mTextToDraw = truncatedText;
                this.mIsRtl = this.calculateIsRtl(this.mTextToDraw);
            }
            switch (this.mExpandedTextGravity & 0x800007) {
                case 1: {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                    break;
                }
                case 5: 
                case 0x800005: {
                    alignment = Layout.Alignment.ALIGN_OPPOSITE;
                    break;
                }
                default: {
                    alignment = Layout.Alignment.ALIGN_NORMAL;
                }
            }
            this.mTextLayout = new StaticLayout(this.mTextToDraw, this.mTextPaint, (int)availableWidth, alignment, this.lineSpacingMultiplier, this.lineSpacingExtra, false);
        }
    }

    private void ensureExpandedTexture() {
        if (this.mExpandedTitleTexture != null || this.mExpandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.mTextToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        int w = this.mTextLayout.getWidth();
        int h = this.mTextLayout.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        this.mExpandedTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.mExpandedTitleTexture);
        this.mTextLayout.draw(c);
        if (this.mTexturePaint == null) {
            this.mTexturePaint = new Paint(3);
        }
    }

    private void ensureCollapsedTexture() {
        if (this.mCollapsedTitleTexture != null || this.mCollapsedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.mTextToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        int w = Math.round(this.mTextPaint.measureText(this.mTextToDraw, 0, this.mTextToDraw.length()));
        int h = Math.round(this.mTextPaint.descent() - this.mTextPaint.ascent());
        if (w <= 0 && h <= 0) {
            return;
        }
        this.mCollapsedTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.mCollapsedTitleTexture);
        c.drawText(this.mTextToDrawCollapsed, 0, this.mTextToDrawCollapsed.length(), 0.0f, -this.mTextPaint.ascent() / this.mScale, (Paint)this.mTextPaint);
        if (this.mTexturePaint == null) {
            this.mTexturePaint = new Paint(3);
        }
    }

    private void ensureCrossSectionTexture() {
        if (this.mCrossSectionTitleTexture != null || this.mCollapsedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.mTextToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        int w = Math.round(this.mTextPaint.measureText(this.mTextToDraw, this.mTextLayout.getLineStart(0), this.mTextLayout.getLineEnd(0)));
        int h = Math.round(this.mTextPaint.descent() - this.mTextPaint.ascent());
        if (w <= 0 && h <= 0) {
            return;
        }
        this.mCrossSectionTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.mCrossSectionTitleTexture);
        String tmp = this.mTextToDrawCollapsed.toString().trim();
        if (tmp.endsWith("\u2026")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        c.drawText(tmp, 0, this.mTextLayout.getLineEnd(0) <= tmp.length() ? this.mTextLayout.getLineEnd(0) : tmp.length(), 0.0f, -this.mTextPaint.ascent() / this.mScale, (Paint)this.mTextPaint);
        if (this.mTexturePaint == null) {
            this.mTexturePaint = new Paint(3);
        }
    }

    public void recalculate() {
        if (this.mView.getHeight() > 0 && this.mView.getWidth() > 0) {
            this.calculateBaseOffsets();
            this.calculateCurrentOffsets();
        }
    }

    void setText(CharSequence text) {
        if (text == null || !text.equals(this.mText)) {
            this.mText = text;
            this.mTextToDraw = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    CharSequence getText() {
        return this.mText;
    }

    private void clearTexture() {
        if (this.mExpandedTitleTexture != null) {
            this.mExpandedTitleTexture.recycle();
            this.mExpandedTitleTexture = null;
        }
        if (this.mCollapsedTitleTexture != null) {
            this.mCollapsedTitleTexture.recycle();
            this.mCollapsedTitleTexture = null;
        }
        if (this.mCrossSectionTitleTexture != null) {
            this.mCrossSectionTitleTexture.recycle();
            this.mCrossSectionTitleTexture = null;
        }
    }

    private static boolean isClose(float value, float targetValue) {
        return Math.abs(value - targetValue) < 0.001f;
    }

    ColorStateList getExpandedTextColor() {
        return this.mExpandedTextColor;
    }

    ColorStateList getCollapsedTextColor() {
        return this.mCollapsedTextColor;
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    private static float lerp(float startValue, float endValue, float fraction, Interpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return AnimationUtils.lerp(startValue, endValue, fraction);
    }

    private static boolean rectEquals(Rect r, int left, int top, int right, int bottom) {
        return r.left == left && r.top == top && r.right == right && r.bottom == bottom;
    }

    static {
        if (DEBUG_DRAW_PAINT != null) {
            DEBUG_DRAW_PAINT.setAntiAlias(true);
            DEBUG_DRAW_PAINT.setColor(-65281);
        }
    }
}

