/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import net.objectlab.kit.datecalc.common.AbstractDateCalculator;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.Utils;
import net.objectlab.kit.datecalc.common.WorkingWeek;
import net.objectlab.kit.datecalc.jdk.CalendarDateCalculator;
import net.objectlab.kit.datecalc.jdk.HolidayHandlerDateWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateDateCalculator
extends AbstractDateCalculator<Date> {
    private CalendarDateCalculator delegate;

    public DateDateCalculator() {
        this(null, null, (HolidayCalendar<Date>)new DefaultHolidayCalendar(Collections.EMPTY_SET), null);
    }

    @Deprecated
    public DateDateCalculator(String name, Date startDate, Set<Date> nonWorkingDays, HolidayHandler<Date> holidayHandler) {
        this(name, startDate, (HolidayCalendar<Date>)new DefaultHolidayCalendar(nonWorkingDays), holidayHandler);
    }

    public DateDateCalculator(String name, Date startDate, HolidayCalendar<Date> holidayCalendar, HolidayHandler<Date> holidayHandler) {
        super(name, holidayCalendar, holidayHandler);
        Date date = startDate;
        HolidayHandlerDateWrapper locDate = new HolidayHandlerDateWrapper(holidayHandler, (DateCalculator<Date>)this);
        HolidayCalendar nonWorkingCalendars = Utils.toHolidayCalendarSet(holidayCalendar);
        if (date == null) {
            date = this.getToday();
        }
        this.delegate = new CalendarDateCalculator(name, Utils.getCal((Date)date), (HolidayCalendar<Calendar>)nonWorkingCalendars, (HolidayHandler<Calendar>)locDate);
        this.delegate.setStartDate(Utils.getCal((Date)date));
        this.setStartDate(date);
    }

    public void setWorkingWeek(WorkingWeek week) {
        this.delegate.setWorkingWeek(week);
    }

    public boolean isWeekend(Date date) {
        if (date != null && this.delegate != null) {
            return this.delegate.isWeekend(Utils.getCal((Date)date));
        }
        return false;
    }

    public DateCalculator<Date> moveByDays(int days) {
        this.setCurrentIncrement(days);
        this.delegate.setCurrentIncrement(days);
        this.delegate.setCurrentBusinessDate(Utils.getCal((Date)((Date)this.getCurrentBusinessDate())));
        this.setCurrentBusinessDate(((Calendar)this.delegate.moveByDays(days).getCurrentBusinessDate()).getTime());
        return this;
    }

    protected DateCalculator<Date> createNewCalculator(String name, Date startDate, HolidayCalendar<Date> holidays, HolidayHandler<Date> handler) {
        return new DateDateCalculator(name, startDate, holidays, handler);
    }

    public void setStartDate(Date startDate) {
        if (this.delegate != null) {
            this.delegate.setStartDate(startDate != null ? Utils.getCal((Date)startDate) : null);
        }
        super.setStartDate((Object)startDate);
    }

    protected Date getToday() {
        return Utils.blastTime((Calendar)Calendar.getInstance()).getTime();
    }

    protected DateCalculator<Date> moveByMonths(int months) {
        this.setCurrentIncrement(months);
        this.delegate.setCurrentIncrement(months);
        this.delegate.setCurrentBusinessDate(Utils.getCal((Date)((Date)this.getCurrentBusinessDate())));
        this.setCurrentBusinessDate(((Calendar)this.delegate.moveByMonths(months).getCurrentBusinessDate()).getTime());
        return this;
    }

    protected Date compareDate(Date date1, Date date2, boolean returnEarliest) {
        if (date1 == null || date2 == null) {
            return null;
        }
        if (returnEarliest) {
            return date1.after(date2) ? date2 : date1;
        }
        return date2.after(date1) ? date2 : date1;
    }

    protected void checkBoundary(Date date) {
        Date early = (Date)this.getHolidayCalendar().getEarlyBoundary();
        if (early != null && early.after(date)) {
            throw new IndexOutOfBoundsException(date + " is before the early boundary " + early);
        }
        Date late = (Date)this.getHolidayCalendar().getLateBoundary();
        if (late != null && late.before(date)) {
            throw new IndexOutOfBoundsException(date + " is after the late boundary " + late);
        }
    }

    protected Date clone(Date date) {
        return new Date(date.getTime());
    }
}

