/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import net.objectlab.kit.datecalc.common.AbstractDateCalculator;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.Utils;
import net.objectlab.kit.datecalc.common.WorkingWeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarDateCalculator
extends AbstractDateCalculator<Calendar> {
    private WorkingWeek workingWeek = WorkingWeek.DEFAULT;

    public CalendarDateCalculator() {
        this(null, null, (HolidayCalendar<Calendar>)new DefaultHolidayCalendar(Collections.EMPTY_SET), null);
    }

    @Deprecated
    public CalendarDateCalculator(String name, Calendar startDate, Set<Calendar> nonWorkingDays, HolidayHandler<Calendar> holidayHandler) {
        this(name, startDate, (HolidayCalendar<Calendar>)new DefaultHolidayCalendar(nonWorkingDays), holidayHandler);
    }

    public CalendarDateCalculator(String name, Calendar startDate, HolidayCalendar<Calendar> holidayCalendar, HolidayHandler<Calendar> holidayHandler) {
        super(name, holidayCalendar, holidayHandler);
        Calendar date = startDate;
        if (date == null) {
            date = this.getToday();
        }
        this.setStartDate(date);
    }

    public void setWorkingWeek(WorkingWeek week) {
        this.workingWeek = week;
    }

    public boolean isWeekend(Calendar date) {
        assert (this.workingWeek != null);
        return !this.workingWeek.isWorkingDay(date);
    }

    public CalendarDateCalculator moveByDays(int days) {
        this.setCurrentIncrement(days);
        ((Calendar)this.getCurrentBusinessDate()).add(5, days);
        if (this.getHolidayHandler() != null) {
            this.setCurrentBusinessDate(this.getHolidayHandler().moveCurrentDate((DateCalculator)this));
        }
        return this;
    }

    public DateCalculator<Calendar> moveByMonths(int months) {
        this.setCurrentIncrement(months);
        Calendar date = (Calendar)this.getCurrentBusinessDate();
        date.add(2, months);
        this.setCurrentBusinessDate(date);
        if (this.getHolidayHandler() != null) {
            this.setCurrentBusinessDate(this.getHolidayHandler().moveCurrentDate((DateCalculator)this));
        }
        return this;
    }

    protected DateCalculator<Calendar> createNewCalculator(String name, Calendar startDate, HolidayCalendar<Calendar> holidays, HolidayHandler<Calendar> handler) {
        return new CalendarDateCalculator(name, startDate, holidays, handler);
    }

    protected Calendar getToday() {
        return Utils.blastTime((Calendar)Calendar.getInstance());
    }

    protected Calendar compareDate(Calendar date1, Calendar date2, boolean returnEarliest) {
        if (date1 == null || date2 == null) {
            return null;
        }
        if (returnEarliest) {
            return date1.after(date2) ? date2 : date1;
        }
        return date2.after(date1) ? date2 : date1;
    }

    protected void checkBoundary(Calendar date) {
        Calendar early = (Calendar)this.getHolidayCalendar().getEarlyBoundary();
        if (early != null && early.after(date)) {
            throw new IndexOutOfBoundsException(date + " is before the early boundary " + early);
        }
        Calendar late = (Calendar)this.getHolidayCalendar().getLateBoundary();
        if (late != null && late.before(date)) {
            throw new IndexOutOfBoundsException(date + " is after the late boundary " + late);
        }
    }

    protected Calendar clone(Calendar date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date.getTime());
        return cal;
    }
}

