/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.objectlab.kit.datecalc.common.DefaultHolidayCalendar;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    private Utils() {
    }

    public static Calendar blastTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date createDate(String dateStr) {
        if (dateStr == null) {
            return Utils.createCalendar(null).getTime();
        }
        try {
            Date date = SDF.parse(dateStr);
            Calendar cal = Utils.getCal(date);
            return cal.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\"" + dateStr + "\"" + " is an invalid date, the pattern is : " + DATE_PATTERN);
        }
    }

    public static Calendar createCalendar(String str) {
        if (str == null) {
            return Utils.blastTime(Calendar.getInstance());
        }
        try {
            Date date = SDF.parse(str);
            Calendar cal = Utils.getCal(date);
            return cal;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\"" + str + "\"" + " is an invalid date, the pattern is : " + DATE_PATTERN);
        }
    }

    public static Calendar getCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return Utils.blastTime(cal);
    }

    public static Set<Calendar> toCalendarSet(Set<Date> dates) {
        HashSet<Calendar> calendars = new HashSet<Calendar>();
        for (Date date : dates) {
            calendars.add(Utils.getCal(date));
        }
        return calendars;
    }

    public static HolidayCalendar<Calendar> toHolidayCalendarSet(HolidayCalendar<Date> dates) {
        HashSet<Calendar> calendars = new HashSet<Calendar>();
        for (Date date : dates.getHolidays()) {
            calendars.add(Utils.getCal(date));
        }
        DefaultHolidayCalendar<Calendar> cal = new DefaultHolidayCalendar<Calendar>(calendars, Utils.getCal(dates.getEarlyBoundary()), Utils.getCal(dates.getLateBoundary()));
        return cal;
    }

    public static Set<Date> toDateSet(Set<Calendar> calendars) {
        HashSet<Date> dates = new HashSet<Date>();
        for (Calendar calendar : calendars) {
            dates.add(calendar.getTime());
        }
        return dates;
    }

    public static List<Date> toDateList(List<Calendar> dates) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        for (Calendar calendar : dates) {
            dateList.add(calendar.getTime());
        }
        return dateList;
    }
}

