/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHolidayCalendar<E>
implements HolidayCalendar<E> {
    private static final long serialVersionUID = -8558686840806739645L;
    private Set<E> holidays;
    private E earlyBoundary = null;
    private E lateBoundary = null;

    public DefaultHolidayCalendar() {
        this.holidays = Collections.emptySet();
    }

    public DefaultHolidayCalendar(Set<E> holidays, E earlyBoundary, E lateBoundary) {
        if (holidays != null) {
            HashSet<E> newSet = new HashSet<E>();
            newSet.addAll(holidays);
            this.holidays = Collections.unmodifiableSet(newSet);
        } else {
            this.holidays = Collections.emptySet();
        }
        this.earlyBoundary = earlyBoundary;
        this.lateBoundary = lateBoundary;
    }

    public DefaultHolidayCalendar(Set<E> holidays) {
        this.holidays = holidays;
    }

    @Override
    public E getEarlyBoundary() {
        return this.earlyBoundary;
    }

    @Override
    public Set<E> getHolidays() {
        return this.holidays;
    }

    @Override
    public E getLateBoundary() {
        return this.lateBoundary;
    }

    @Override
    public void setEarlyBoundary(E earlyBoundary) {
        this.earlyBoundary = earlyBoundary;
    }

    @Override
    public void setHolidays(Set<E> holidays) {
        HashSet<E> s = new HashSet<E>();
        s.addAll(holidays);
        this.holidays = Collections.unmodifiableSet(s);
    }

    @Override
    public void setLateBoundary(E lateBoundary) {
        this.lateBoundary = lateBoundary;
    }

    @Override
    public boolean isHoliday(E date) {
        return this.holidays.contains(date);
    }
}

