/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Calendar;
import java.util.Date;
import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;
import net.objectlab.kit.datecalc.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolidayHandlerDateWrapper
implements HolidayHandler<Calendar> {
    private final HolidayHandler<Date> delegate;
    private final BaseCalculator<Date> calculator;

    public HolidayHandlerDateWrapper(HolidayHandler<Date> holidayHandler, BaseCalculator<Date> dateCalculator) {
        this.delegate = holidayHandler;
        this.calculator = dateCalculator;
    }

    public Calendar moveCurrentDate(BaseCalculator<Calendar> calc) {
        return this.adjustDate((Calendar)calc.getCurrentBusinessDate(), 1, (NonWorkingDayChecker<Calendar>)calc);
    }

    public Calendar adjustDate(Calendar startDate, int increment, NonWorkingDayChecker<Calendar> checker) {
        Date day;
        Calendar ret = startDate;
        if (this.delegate != null && (day = (Date)this.delegate.moveCurrentDate(this.calculator)) != null) {
            ret = Utils.getCal((Date)day);
        }
        return ret;
    }

    public String getType() {
        return this.delegate.getType();
    }
}

