/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.objectlab.kit.datecalc.common.AbstractIMMDateCalculator;
import net.objectlab.kit.datecalc.common.IMMPeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarIMMDateCalculator
extends AbstractIMMDateCalculator<Calendar> {
    private static final int NUMBER_DAYS_IN_WEEK = 7;

    public List<Calendar> getIMMDates(Calendar start, Calendar end, IMMPeriod period) {
        ArrayList<Calendar> dates = new ArrayList<Calendar>();
        Calendar cal = (Calendar)start.clone();
        while (!(cal = this.getNextIMMDate(true, cal, period)).after(end)) {
            dates.add(cal);
        }
        return dates;
    }

    protected Calendar getNextIMMDate(boolean requestNextIMM, Calendar startDate, IMMPeriod period) {
        Calendar cal = (Calendar)startDate.clone();
        if (this.isIMMMonth(cal)) {
            this.moveToIMMDay(cal);
            if (requestNextIMM && cal.after(startDate) || !requestNextIMM && cal.before(startDate)) {
                return cal;
            }
        }
        int delta = requestNextIMM ? 1 : -1;
        do {
            cal.add(2, delta);
        } while (!this.isIMMMonth(cal));
        this.moveToIMMDay(cal);
        cal = this.handlePeriod(requestNextIMM, period, cal);
        return cal;
    }

    private Calendar handlePeriod(boolean requestNextIMM, IMMPeriod period, Calendar givenCal) {
        Calendar cal = givenCal;
        int month = cal.get(2);
        switch (period) {
            case BI_ANNUALY_JUN_DEC: {
                if (month != 2 && month != 8) break;
                cal = this.getNextIMMDate(requestNextIMM, cal, period);
                break;
            }
            case BI_ANNUALY_MAR_SEP: {
                if (month != 5 && month != 11) break;
                cal = this.getNextIMMDate(requestNextIMM, cal, period);
                break;
            }
            case ANNUALLY: {
                cal = this.getNextIMMDate(requestNextIMM, cal, IMMPeriod.QUARTERLY);
                cal = this.getNextIMMDate(requestNextIMM, cal, IMMPeriod.QUARTERLY);
                cal = this.getNextIMMDate(requestNextIMM, cal, IMMPeriod.QUARTERLY);
                cal = this.getNextIMMDate(requestNextIMM, cal, IMMPeriod.QUARTERLY);
                break;
            }
        }
        return cal;
    }

    private boolean isIMMMonth(Calendar cal) {
        int month = cal.get(2);
        switch (month) {
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private void moveToIMMDay(Calendar cal) {
        cal.set(5, 1);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek < 4) {
            cal.add(5, 4 - dayOfWeek);
        } else if (dayOfWeek > 4) {
            cal.add(5, 11 - dayOfWeek);
        }
        cal.add(5, 14);
    }

    public boolean isIMMDate(Calendar date) {
        Calendar cal = (Calendar)date.clone();
        this.moveToIMMDay(cal);
        return cal.equals(date);
    }
}

