/*
 * Decompiled with CFR 0.152.
 */
package net.niebes.retrofit.metrics;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.niebes.retrofit.metrics.MeasuredCall;
import net.niebes.retrofit.metrics.RetrofitCallMetricsCollector;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.CallAdapter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B#\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u00028\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/niebes/retrofit/metrics/MeasuredCallAdapter;", "OriginalType", "TargetType", "Lretrofit2/CallAdapter;", "nextCallAdapter", "metricsCollector", "Lnet/niebes/retrofit/metrics/RetrofitCallMetricsCollector;", "(Lretrofit2/CallAdapter;Lnet/niebes/retrofit/metrics/RetrofitCallMetricsCollector;)V", "adapt", "call", "Lretrofit2/Call;", "(Lretrofit2/Call;)Ljava/lang/Object;", "responseType", "Ljava/lang/reflect/Type;", "retrofit-metrics"})
public final class MeasuredCallAdapter<OriginalType, TargetType>
implements CallAdapter<OriginalType, TargetType> {
    @NotNull
    private final CallAdapter<OriginalType, TargetType> nextCallAdapter;
    @NotNull
    private final RetrofitCallMetricsCollector metricsCollector;

    public MeasuredCallAdapter(@NotNull CallAdapter<OriginalType, TargetType> nextCallAdapter, @NotNull RetrofitCallMetricsCollector metricsCollector) {
        Intrinsics.checkNotNullParameter(nextCallAdapter, (String)"nextCallAdapter");
        Intrinsics.checkNotNullParameter((Object)metricsCollector, (String)"metricsCollector");
        this.nextCallAdapter = nextCallAdapter;
        this.metricsCollector = metricsCollector;
    }

    @NotNull
    public Type responseType() {
        Type type = this.nextCallAdapter.responseType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"nextCallAdapter.responseType()");
        return type;
    }

    public TargetType adapt(@NotNull Call<OriginalType> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        return (TargetType)this.nextCallAdapter.adapt((Call)new MeasuredCall<OriginalType>(call, this.metricsCollector));
    }
}

