/*
 * Decompiled with CFR 0.152.
 */
package net.niebes.retrofit.metrics;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.niebes.retrofit.metrics.HttpSeries;
import net.niebes.retrofit.metrics.MetricsRecorder;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/niebes/retrofit/metrics/RetrofitCallMetricsCollector;", "", "baseUrl", "", "uri", "metricsRecorder", "Lnet/niebes/retrofit/metrics/MetricsRecorder;", "(Ljava/lang/String;Ljava/lang/String;Lnet/niebes/retrofit/metrics/MetricsRecorder;)V", "measureRequestDuration", "", "duration", "Ljava/time/Duration;", "request", "Lokhttp3/Request;", "response", "Lretrofit2/Response;", "async", "", "measureRequestException", "throwable", "", "retrofit-metrics"})
public final class RetrofitCallMetricsCollector {
    private final String baseUrl;
    private final String uri;
    private final MetricsRecorder metricsRecorder;

    public final void measureRequestDuration(@NotNull Duration duration, @NotNull Request request, @NotNull Response<? extends Object> response, boolean async) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"base_url", (Object)this.baseUrl);
        pairArray[1] = TuplesKt.to((Object)"uri", (Object)this.uri);
        pairArray[2] = TuplesKt.to((Object)"method", (Object)request.method());
        Object object = HttpSeries.Companion.fromHttpStatus(response.code());
        if (object == null || (object = object.name()) == null) {
            object = "UNKNOWN";
        }
        pairArray[3] = TuplesKt.to((Object)"series", (Object)object);
        pairArray[4] = TuplesKt.to((Object)"status", (Object)String.valueOf(response.code()));
        pairArray[5] = TuplesKt.to((Object)"async", (Object)String.valueOf(async));
        pairArray[6] = TuplesKt.to((Object)"exception", (Object)"None");
        this.metricsRecorder.recordTiming(MapsKt.mapOf((Pair[])pairArray), duration);
    }

    public final void measureRequestException(@NotNull Duration duration, @NotNull Request request, @NotNull Throwable throwable, boolean async) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        this.metricsRecorder.recordTiming(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"base_url", (Object)this.baseUrl), TuplesKt.to((Object)"method", (Object)request.method()), TuplesKt.to((Object)"uri", (Object)this.uri), TuplesKt.to((Object)"async", (Object)String.valueOf(async)), TuplesKt.to((Object)"exception", (Object)throwable.getClass().getSimpleName())}), duration);
    }

    public RetrofitCallMetricsCollector(@NotNull String baseUrl, @NotNull String uri, @NotNull MetricsRecorder metricsRecorder) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)metricsRecorder, (String)"metricsRecorder");
        this.baseUrl = baseUrl;
        this.uri = uri;
        this.metricsRecorder = metricsRecorder;
    }
}

