/*
 * Decompiled with CFR 0.152.
 */
package net.niebes.retrofit.metrics;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.niebes.retrofit.metrics.RetrofitCallMetricsCollector;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/niebes/retrofit/metrics/MeasuredCall;", "T", "Lretrofit2/Call;", "wrappedCall", "metrics", "Lnet/niebes/retrofit/metrics/RetrofitCallMetricsCollector;", "(Lretrofit2/Call;Lnet/niebes/retrofit/metrics/RetrofitCallMetricsCollector;)V", "cancel", "", "clone", "enqueue", "callback", "Lretrofit2/Callback;", "execute", "Lretrofit2/Response;", "isCanceled", "", "isExecuted", "measuredCallback", "request", "Lokhttp3/Request;", "retrofit-metrics"})
public final class MeasuredCall<T>
implements Call<T> {
    private final Call<T> wrappedCall;
    private final RetrofitCallMetricsCollector metrics;

    @NotNull
    public Response<T> execute() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Request request = this.wrappedCall.request();
        try {
            Response response = this.wrappedCall.execute();
            Duration duration = stopwatch.elapsed();
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"stopwatch.elapsed()");
            Request request2 = request;
            Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            this.metrics.measureRequestDuration(duration, request2, (Response<? extends Object>)response2, false);
            return response;
        }
        catch (Exception exception) {
            Duration duration = stopwatch.elapsed();
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"stopwatch.elapsed()");
            Request request3 = request;
            Intrinsics.checkExpressionValueIsNotNull((Object)request3, (String)"request");
            this.metrics.measureRequestException(duration, request3, exception, false);
            throw (Throwable)exception;
        }
    }

    public void enqueue(@NotNull Callback<T> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Request request = this.wrappedCall.request();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"wrappedCall.request()");
        this.wrappedCall.enqueue(this.measuredCallback(request, callback));
    }

    private final Callback<T> measuredCallback(Request request, Callback<T> callback) {
        return new Callback<T>(this, request, callback){
            private final Stopwatch stopwatch;
            final /* synthetic */ MeasuredCall this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ Callback $callback;

            public final Stopwatch getStopwatch() {
                return this.stopwatch;
            }

            public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                RetrofitCallMetricsCollector retrofitCallMetricsCollector = MeasuredCall.access$getMetrics$p(this.this$0);
                Duration duration = this.stopwatch.elapsed();
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"stopwatch.elapsed()");
                retrofitCallMetricsCollector.measureRequestDuration(duration, this.$request, response, true);
                this.$callback.onResponse(call, response);
            }

            public void onFailure(@NotNull Call<T> call, @NotNull Throwable throwable) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                RetrofitCallMetricsCollector retrofitCallMetricsCollector = MeasuredCall.access$getMetrics$p(this.this$0);
                Duration duration = this.stopwatch.elapsed();
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"stopwatch.elapsed()");
                retrofitCallMetricsCollector.measureRequestException(duration, this.$request, throwable, true);
                this.$callback.onFailure(call, throwable);
            }
            {
                this.this$0 = $outer;
                this.$request = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                this.stopwatch = Stopwatch.createStarted();
            }
        };
    }

    public boolean isExecuted() {
        return this.wrappedCall.isExecuted();
    }

    public boolean isCanceled() {
        return this.wrappedCall.isCanceled();
    }

    public void cancel() {
        this.wrappedCall.cancel();
    }

    @NotNull
    public Call<T> clone() {
        Call call = this.wrappedCall.clone();
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"wrappedCall.clone()");
        return new MeasuredCall<T>(call, this.metrics);
    }

    @NotNull
    public Request request() {
        Request request = this.wrappedCall.request();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"wrappedCall.request()");
        return request;
    }

    public MeasuredCall(@NotNull Call<T> wrappedCall, @NotNull RetrofitCallMetricsCollector metrics) {
        Intrinsics.checkParameterIsNotNull(wrappedCall, (String)"wrappedCall");
        Intrinsics.checkParameterIsNotNull((Object)metrics, (String)"metrics");
        this.wrappedCall = wrappedCall;
        this.metrics = metrics;
    }

    public static final /* synthetic */ RetrofitCallMetricsCollector access$getMetrics$p(MeasuredCall $this) {
        return $this.metrics;
    }
}

