package net.niebes.retrofit.metrics

import java.time.Duration
import okhttp3.Request
import retrofit2.Response

class RetrofitCallMetricsCollector(
  private val baseUrl: String,
  private val uri: String,
  private val metricsRecorder: MetricsRecorder
) {

    fun measureRequestDuration(
      duration: Duration,
      request: Request,
      response: Response<out Any?>,
      async: Boolean
    ) = metricsRecorder.recordTiming(mapOf(
        "base_url" to baseUrl,
        "uri" to uri,
        "method" to request.method,
        "series" to (HttpSeries.fromHttpStatus(response.code())?.name ?: "UNKNOWN"),
        "status" to response.code().toString(),
        "async" to async.toString(),
        "exception" to "None"
    ), duration)

    fun measureRequestException(
      duration: Duration,
      request: Request,
      throwable: Throwable,
      async: Boolean
    ) = metricsRecorder.recordTiming(mapOf(
        "base_url" to baseUrl,
        "method" to request.method,
        "uri" to uri,
        "async" to async.toString(),
        "exception" to throwable.javaClass.simpleName
    ), duration)
}
