/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.routing.datasource;

import net.n2oapp.routing.datasource.JndiContextHolder;
import net.n2oapp.routing.datasource.RoutingDataSourceCallback;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JndiRoutingDataSourceTemplate {
    private TransactionTemplate transactionTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String jndiName, RoutingDataSourceCallback<T> action) {
        JndiContextHolder.setJndiContext(jndiName);
        try {
            T t = action.onRouting();
            return t;
        }
        finally {
            JndiContextHolder.clearJndiContext();
        }
    }

    public <T> T execute(String jndiName, TransactionCallback<T> action) {
        if (this.transactionTemplate == null) {
            throw new IllegalStateException("transactionTemplate is null");
        }
        return (T)this.execute(jndiName, () -> this.transactionTemplate.execute(action));
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }
}

