/*
 * Decompiled with CFR 0.152.
 */
package net.mostlyoriginal.api.system.physics;

import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.annotations.Wire;
import com.artemis.systems.VoidEntitySystem;
import net.mostlyoriginal.api.component.basic.Bounds;
import net.mostlyoriginal.api.component.basic.Pos;

@Wire
public class CollisionSystem
extends VoidEntitySystem {
    private ComponentMapper<Bounds> bm;
    private ComponentMapper<Pos> pm;

    public final boolean overlaps(Entity a, Entity b) {
        Bounds b1 = (Bounds)this.bm.getSafe(a);
        Pos p1 = (Pos)this.pm.getSafe(a);
        Bounds b2 = (Bounds)this.bm.getSafe(b);
        Pos p2 = (Pos)this.pm.getSafe(b);
        if (b1 == null || p1 == null || b2 == null || p2 == null) {
            return false;
        }
        float minx = p1.x + (float)b1.minx;
        float miny = p1.y + (float)b1.miny;
        float maxx = p1.x + (float)b1.maxx;
        float maxy = p1.y + (float)b1.maxy;
        float bminx = p2.x + (float)b2.minx;
        float bminy = p2.y + (float)b2.miny;
        float bmaxx = p2.x + (float)b2.maxx;
        float bmaxy = p2.y + (float)b2.maxy;
        return !(minx > bmaxx || maxx < bminx || miny > bmaxy || maxy < bminy);
    }

    protected void processSystem() {
    }
}

