/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.endpoints;

import com.testflightapp.lib.TestFlight;
import com.testflightapp.lib.core.networking.HttpRequest;
import com.testflightapp.lib.core.networking.IEndpoint;
import com.testflightapp.lib.core.networking.encoding.DecoderFormatException;
import com.testflightapp.lib.core.networking.encoding.IParameterDecoder;
import com.testflightapp.lib.core.networking.encoding.IParameterEncoder;
import com.testflightapp.lib.core.networking.encoding.MPParameterDecoder;
import com.testflightapp.lib.core.networking.encoding.MPParameterEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;

public class TokensEndpoint
implements IEndpoint {
    public static final String NAME = "tokens";
    private static final String RELATIVE_PATH = "/flightdeck/1.0/tokens.mpack";
    private static final Map<String, String> HEADERS = new HashMap<String, String>();
    private final String mHost;
    private final IParameterEncoder mEncoder;
    private final IParameterDecoder mDecoder;

    public TokensEndpoint(String string) {
        this.mHost = string;
        this.mEncoder = new MPParameterEncoder();
        this.mDecoder = new MPParameterDecoder();
    }

    @Override
    public HttpRequest generateRequest(Map<String, Object> map, Map<String, Object> map2, Map<String, Object> map3) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("device_info", map);
        treeMap.put("bundle_info", map2);
        treeMap.put("application_token", TestFlight.getAppToken());
        HttpEntity httpEntity = this.mEncoder.encode(treeMap);
        return HttpRequest.createPost(this.mHost + RELATIVE_PATH, HEADERS, httpEntity);
    }

    @Override
    public Map<String, Object> parseResponse(HttpEntity httpEntity) throws DecoderFormatException {
        return this.mDecoder.decode(httpEntity);
    }

    static {
        HEADERS.put("Content-Type", "application/x-msgpack");
    }
}

