/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import android.content.Context;
import android.util.Log;
import com.testflightapp.lib.TestFlight;
import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.SqliteObjectPersistor;
import com.testflightapp.lib.core.networking.HttpRequest;
import com.testflightapp.lib.core.networking.IEndpoint;
import com.testflightapp.lib.core.newapi.ConnectionStateWatcher;
import com.testflightapp.lib.core.newapi.IJobScheduler;
import com.testflightapp.lib.core.newapi.SchedulerAwareJob;
import com.testflightapp.lib.endpoints.SessionsEndpoint;
import com.testflightapp.lib.events.SessionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;

public class SessionJob
extends SchedulerAwareJob
implements ConnectionStateWatcher.IConnectivityListener {
    public static final int MAX_EVENTS_FOR_SEND = 50;
    public static final int MIN_EVENTS_FOR_SEND = 10;
    private static final String TAG = SessionJob.class.getSimpleName();
    private static final int HTTP_TIMEOUT_MS = 10000;
    private static final int WAIT_TIME_ON_FAILURE = 10000;
    private static final int MAX_TIME_MILLIS_FOR_SEND = 30000;
    private static long sTimeAtLastEventSend;
    private INetworkJobListener mListener;
    private IEndpoint mSessionsEndpoint;
    private boolean mStoreSessionEvents;
    private volatile boolean mFlush;
    private SqliteObjectPersistor<SessionEvent> mEvents;

    public SessionJob(Context context, INetworkJobListener iNetworkJobListener, String string, Map<String, Object> map) {
        super("Session Job");
        this.mListener = iNetworkJobListener;
        this.mSessionsEndpoint = new SessionsEndpoint(string);
        try {
            this.mEvents = new SqliteObjectPersistor(context, "testflight_session_events", map);
            this.mStoreSessionEvents = true;
        }
        catch (IOException iOException) {
            Logger.e("Unable to open SessionEvent DB", iOException);
        }
    }

    @Override
    protected void runJob() {
        Logger.d("Executing Network job");
        this.processSessionData();
    }

    @Override
    void setScheduler(IJobScheduler iJobScheduler) {
        super.setScheduler(iJobScheduler);
        iJobScheduler.addJob(this);
    }

    private void processSessionData() {
        Object object;
        if (!this.mStoreSessionEvents) {
            return;
        }
        Logger.d(TAG, "Processing session data");
        ArrayList<SessionEvent> arrayList = this.getEventsThatShouldBeSent();
        int n = arrayList.size();
        if (n > 0) {
            object = this.mEvents.getBundleInfoForEvent(arrayList.get(0));
            SessionEvent[] sessionEventArray = new SessionEvent[n];
            arrayList.toArray(sessionEventArray);
            if (this.sendEvents((Map<String, Object>)object, sessionEventArray)) {
                Logger.d(TAG, "Successfully sent " + n + " events.");
                this.mEvents.removeEvents(sessionEventArray);
                sTimeAtLastEventSend = System.currentTimeMillis();
            }
        } else {
            Logger.d(TAG, "No events to process");
            this.mFlush = false;
        }
        object = this.getScheduler();
        if (object != null && this.getRecurrentInterval() == 0L && this.shouldSendEvents()) {
            Logger.d(TAG, "There are cached events to send, rescheduling sending events...");
            object.addJob(this);
        }
    }

    protected ArrayList<SessionEvent> getEventsThatShouldBeSent() {
        ArrayList<SessionEvent> arrayList = new ArrayList<SessionEvent>();
        if (!this.shouldSendEvents()) {
            return arrayList;
        }
        int n = this.mEvents.getEventCount();
        int n2 = Math.min(50, n);
        long l = -1L;
        for (int i = 0; i < n2; ++i) {
            SessionEvent sessionEvent = this.mEvents.getEvent(i);
            if (l == -1L) {
                l = sessionEvent.getBundleInfoPersistenceId();
            }
            if (l != sessionEvent.getBundleInfoPersistenceId()) {
                n2 = i;
                continue;
            }
            arrayList.add(sessionEvent);
        }
        return arrayList;
    }

    protected boolean shouldSendEvents() {
        if (this.mStoreSessionEvents) {
            int n = this.mEvents.getEventCount();
            if (n < 1) {
                return false;
            }
            if (sTimeAtLastEventSend < 1L) {
                sTimeAtLastEventSend = System.currentTimeMillis();
            }
            long l = System.currentTimeMillis() - sTimeAtLastEventSend;
            if (this.mFlush || n >= 10 || l > 30000L) {
                this.mFlush = false;
                return true;
            }
        }
        return false;
    }

    private boolean sendEvents(Map<String, Object> map, SessionEvent[] sessionEventArray) {
        Logger.d(TAG, "Will send " + sessionEventArray.length + " events: " + Arrays.toString(sessionEventArray));
        try {
            Map<String, Object> map2;
            String string;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            SessionEvent.packEvents(sessionEventArray, hashMap);
            Map<String, Object> map3 = TestFlight.getDeviceInfo();
            HttpRequest httpRequest = this.mSessionsEndpoint.generateRequest(map3, map, hashMap);
            HttpResponse httpResponse = httpRequest.executeRequest(10000);
            if (httpResponse.getStatusLine().getStatusCode() == 200 && "yup".equalsIgnoreCase(string = (String)(map2 = this.mSessionsEndpoint.parseResponse(httpResponse.getEntity())).get("ok"))) {
                this.mListener.onSessionsRequestFinished(this, sessionEventArray, null);
                this.setRecurrentInterval(0L);
                return true;
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Error sending events. Attempt rescheduled in 10000 ms: " + exception);
        }
        this.setRecurrentInterval(10000L);
        return false;
    }

    public void clearAllEvents() {
        if (this.mStoreSessionEvents) {
            this.mEvents.clearEvents();
        }
    }

    public boolean addEvent(SessionEvent sessionEvent) {
        return this.addEvent(sessionEvent, true);
    }

    protected boolean addEvent(SessionEvent sessionEvent, boolean bl) {
        boolean bl2 = false;
        if (this.mStoreSessionEvents) {
            bl2 = this.mEvents.persistEvent(sessionEvent) == 1;
            IJobScheduler iJobScheduler = this.getScheduler();
            if (bl && iJobScheduler != null && this.shouldSendEvents()) {
                iJobScheduler.addJob(this);
            }
            Log.d((String)TAG, (String)("Total events collected - " + this.getEventCount()));
        }
        return bl2;
    }

    public int getEventCount() {
        return this.mStoreSessionEvents ? this.mEvents.getEventCount() : 0;
    }

    public void flushEvents() {
        this.mFlush = true;
    }

    public boolean isFlushing() {
        return this.mFlush;
    }

    @Override
    protected int getJobId() {
        return 1;
    }

    @Override
    public void onConnected() {
        IJobScheduler iJobScheduler = this.getScheduler();
        if (iJobScheduler != null) {
            iJobScheduler.addJob(this);
        }
    }

    @Override
    public void onDisconnected() {
        IJobScheduler iJobScheduler = this.getScheduler();
        if (iJobScheduler != null) {
            iJobScheduler.removeJob(this);
        }
    }

    public static interface INetworkJobListener {
        public void onSessionsRequestFinished(SessionJob var1, SessionEvent[] var2, Map<String, Object> var3);
    }
}

