/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringUtils {
    public static String sha1(String string) {
        try {
            if (string == null) {
                return null;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string.getBytes());
            return StringUtils.bytesToString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SHA-1 algorithm implementation is not found on device!");
        }
    }

    public static String bytesToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(0xFF & by);
            if (string.length() == 1) {
                stringBuilder.append("0").append(string);
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

