/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class TestFlightProperties {
    public static final String TAG = TestFlightProperties.class.getName();
    private static Properties sProperties = new Properties();
    private static volatile boolean sIsLoaded;

    private TestFlightProperties() {
    }

    private static void initProperties() {
        if (!sIsLoaded) {
            sIsLoaded = true;
            TestFlightProperties.loadPropertiesFromFile("/res/raw/tf.properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertiesFromFile(String string) {
        InputStream inputStream = TestFlightProperties.class.getResourceAsStream(string);
        try {
            sProperties.load(inputStream);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("FATAL ERROR! Application could not find properties file: " + string));
            sIsLoaded = false;
        }
        finally {
            TestFlightProperties.close(inputStream);
        }
    }

    private static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getString(String string) {
        TestFlightProperties.initProperties();
        if (sIsLoaded) {
            return sProperties.getProperty(string, "Can not find property with key :" + string);
        }
        return "Property file is not initialized!";
    }

    public static class PropertyKey {
        public static final String SDK_VERSION = "tfsdk.version";
    }
}

