/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra;

import android.content.Context;
import android.util.Log;
import com.testflightapp.acra.ACRA;
import java.io.File;
import java.io.FilenameFilter;

final class CrashReportFinder {
    private final Context context;

    public CrashReportFinder(Context context) {
        this.context = context;
    }

    public String[] getCrashReportFiles() {
        if (this.context == null) {
            Log.e((String)ACRA.LOG_TAG, (String)"Trying to get ACRA reports but ACRA is not initialized.");
            return new String[0];
        }
        File dir = this.context.getFilesDir();
        if (dir == null) {
            Log.w((String)ACRA.LOG_TAG, (String)"Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
            return new String[0];
        }
        Log.d((String)ACRA.LOG_TAG, (String)("Looking for error files in " + dir.getAbsolutePath()));
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".stacktrace");
            }
        };
        String[] result = dir.list(filter);
        return result == null ? new String[]{} : result;
    }
}

