/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils.facebook;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.bzutils.facebook.DialogError;
import com.bzutils.facebook.FacebookError;
import com.bzutils.facebook.FbDialog;
import com.bzutils.facebook.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;

public class Facebook {
    public static final String REDIRECT_URI = "fbconnect://success";
    public static final String CANCEL_URI = "fbconnect://cancel";
    public static final String TOKEN = "access_token";
    public static final String EXPIRES = "expires_in";
    public static final String SINGLE_SIGN_ON_DISABLED = "service_disabled";
    public static final int FORCE_DIALOG_AUTH = -1;
    private static final String LOGIN = "oauth";
    private static final int DEFAULT_AUTH_ACTIVITY_CODE = 32665;
    protected static String DIALOG_BASE_URL = "https://m.facebook.com/dialog/";
    protected static String GRAPH_BASE_URL = "https://graph.facebook.com/";
    protected static String RESTSERVER_URL = "https://api.facebook.com/restserver.php";
    private String mAccessToken = null;
    private long mLastAccessUpdate = 0L;
    private long mAccessExpires = 0L;
    private String mAppId;
    private Activity mAuthActivity;
    private String[] mAuthPermissions;
    private int mAuthActivityCode;
    private DialogListener mAuthDialogListener;
    private final long REFRESH_TOKEN_BARRIER = 86400000L;
    protected static String DIALOG_BASE_URL_FOR_MISSING_SCREENS = "https://www.facebook.com/dialog/";
    public static final String FB_APP_SIGNATURE = "30820268308201d102044a9c4610300d06092a864886f70d0101040500307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e3020170d3039303833313231353231365a180f32303530303932353231353231365a307a310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f31183016060355040a130f46616365626f6f6b204d6f62696c653111300f060355040b130846616365626f6f6b311d301b0603550403131446616365626f6f6b20436f72706f726174696f6e30819f300d06092a864886f70d010101050003818d0030818902818100c207d51df8eb8c97d93ba0c8c1002c928fab00dc1b42fca5e66e99cc3023ed2d214d822bc59e8e35ddcf5f44c7ae8ade50d7e0c434f500e6c131f4a2834f987fc46406115de2018ebbb0d5a3c261bd97581ccfef76afc7135a6d59e8855ecd7eacc8f8737e794c60a761c536b72b11fac8e603f5da1a2d54aa103b8a13c0dbc10203010001300d06092a864886f70d0101040500038181005ee9be8bcbb250648d3b741290a82a1c9dc2e76a0af2f2228f1d9f9c4007529c446a70175c5a900d5141812866db46be6559e2141616483998211f4a673149fb2232a10d247663b26a9031e15f84bc1c74d141ff98a02d76f85b2c8ab2571b6469b232d8e768a7f7ca04f7abe4a775615916c07940656b58717457b42bd928a2";

    public Facebook(String appId) {
        if (appId == null) {
            throw new IllegalArgumentException("You must specify your application ID when instantiating a Facebook object. See README for details.");
        }
        this.mAppId = appId;
    }

    public void authorize(Activity activity, DialogListener listener) {
        this.authorize(activity, new String[0], 32665, listener);
    }

    public void authorize(Activity activity, String[] permissions, DialogListener listener) {
        this.authorize(activity, permissions, 32665, listener);
    }

    public void authorize(Activity activity, String[] permissions, int activityCode, DialogListener listener) {
        boolean singleSignOnStarted = false;
        this.mAuthDialogListener = listener;
        if (activityCode >= 0) {
            singleSignOnStarted = this.startSingleSignOn(activity, this.mAppId, permissions, activityCode);
        }
        if (!singleSignOnStarted) {
            this.startDialogAuth(activity, permissions);
        }
    }

    private boolean startSingleSignOn(Activity activity, String applicationId, String[] permissions, int activityCode) {
        boolean didSucceed = true;
        Intent intent = new Intent();
        intent.setClassName("com.facebook.katana", "com.facebook.katana.ProxyAuth");
        intent.putExtra("client_id", applicationId);
        if (permissions.length > 0) {
            intent.putExtra("scope", TextUtils.join((CharSequence)",", (Object[])permissions));
        }
        if (!this.validateActivityIntent((Context)activity, intent)) {
            return false;
        }
        this.mAuthActivity = activity;
        this.mAuthPermissions = permissions;
        this.mAuthActivityCode = activityCode;
        try {
            activity.startActivityForResult(intent, activityCode);
        }
        catch (ActivityNotFoundException e) {
            didSucceed = false;
        }
        return didSucceed;
    }

    private boolean validateActivityIntent(Context context, Intent intent) {
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        return this.validateAppSignatureForPackage(context, resolveInfo.activityInfo.packageName);
    }

    private boolean validateServiceIntent(Context context, Intent intent) {
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        return this.validateAppSignatureForPackage(context, resolveInfo.serviceInfo.packageName);
    }

    private boolean validateAppSignatureForPackage(Context context, String packageName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            if (!signature.toCharsString().equals(FB_APP_SIGNATURE)) continue;
            return true;
        }
        return false;
    }

    private void startDialogAuth(Activity activity, String[] permissions) {
        Bundle params = new Bundle();
        if (permissions.length > 0) {
            params.putString("scope", TextUtils.join((CharSequence)",", (Object[])permissions));
        }
        CookieSyncManager.createInstance((Context)activity);
        this.dialog((Context)activity, LOGIN, params, new DialogListener(){

            @Override
            public void onComplete(Bundle values) {
                CookieSyncManager.getInstance().sync();
                Facebook.this.setAccessToken(values.getString(Facebook.TOKEN));
                Facebook.this.setAccessExpiresIn(values.getString(Facebook.EXPIRES));
                if (Facebook.this.isSessionValid()) {
                    Util.logd("Facebook-authorize", "Login Success! access_token=" + Facebook.this.getAccessToken() + " expires=" + Facebook.this.getAccessExpires());
                    Facebook.this.mAuthDialogListener.onComplete(values);
                } else {
                    Facebook.this.mAuthDialogListener.onFacebookError(new FacebookError("Failed to receive access token."));
                }
            }

            @Override
            public void onError(DialogError error) {
                Util.logd("Facebook-authorize", "Login failed: " + error);
                Facebook.this.mAuthDialogListener.onError(error);
            }

            @Override
            public void onFacebookError(FacebookError error) {
                Util.logd("Facebook-authorize", "Login failed: " + error);
                Facebook.this.mAuthDialogListener.onFacebookError(error);
            }

            @Override
            public void onCancel() {
                Util.logd("Facebook-authorize", "Login canceled");
                Facebook.this.mAuthDialogListener.onCancel();
            }
        });
    }

    public void authorizeCallback(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.mAuthActivityCode) {
            if (resultCode == -1) {
                String error = data.getStringExtra("error");
                if (error == null) {
                    error = data.getStringExtra("error_type");
                }
                if (error != null) {
                    if (error.equals(SINGLE_SIGN_ON_DISABLED) || error.equals("AndroidAuthKillSwitchException")) {
                        Util.logd("Facebook-authorize", "Hosted auth currently disabled. Retrying dialog auth...");
                        this.startDialogAuth(this.mAuthActivity, this.mAuthPermissions);
                    } else if (error.equals("access_denied") || error.equals("OAuthAccessDeniedException")) {
                        Util.logd("Facebook-authorize", "Login canceled by user.");
                        this.mAuthDialogListener.onCancel();
                    } else {
                        String description = data.getStringExtra("error_description");
                        if (description != null) {
                            error = error + ":" + description;
                        }
                        Util.logd("Facebook-authorize", "Login failed: " + error);
                        this.mAuthDialogListener.onFacebookError(new FacebookError(error));
                    }
                } else {
                    this.setAccessToken(data.getStringExtra(TOKEN));
                    this.setAccessExpiresIn(data.getStringExtra(EXPIRES));
                    if (this.isSessionValid()) {
                        Util.logd("Facebook-authorize", "Login Success! access_token=" + this.getAccessToken() + " expires=" + this.getAccessExpires());
                        this.mAuthDialogListener.onComplete(data.getExtras());
                    } else {
                        this.mAuthDialogListener.onFacebookError(new FacebookError("Failed to receive access token."));
                    }
                }
            } else if (resultCode == 0) {
                if (data != null) {
                    Util.logd("Facebook-authorize", "Login failed: " + data.getStringExtra("error"));
                    this.mAuthDialogListener.onError(new DialogError(data.getStringExtra("error"), data.getIntExtra("error_code", -1), data.getStringExtra("failing_url")));
                } else {
                    Util.logd("Facebook-authorize", "Login canceled by user.");
                    this.mAuthDialogListener.onCancel();
                }
            }
        }
    }

    public boolean extendAccessToken(Context context, ServiceListener serviceListener) {
        Intent intent = new Intent();
        intent.setClassName("com.facebook.katana", "com.facebook.katana.platform.TokenRefreshService");
        if (!this.validateServiceIntent(context, intent)) {
            return false;
        }
        return context.bindService(intent, (ServiceConnection)new TokenRefreshServiceConnection(context, serviceListener), 1);
    }

    public boolean extendAccessTokenIfNeeded(Context context, ServiceListener serviceListener) {
        if (this.shouldExtendAccessToken()) {
            return this.extendAccessToken(context, serviceListener);
        }
        return true;
    }

    public boolean shouldExtendAccessToken() {
        return this.isSessionValid() && System.currentTimeMillis() - this.mLastAccessUpdate >= 86400000L;
    }

    public String logout(Context context) throws MalformedURLException, IOException {
        Util.clearCookies(context);
        Bundle b = new Bundle();
        b.putString("method", "auth.expireSession");
        String response = this.request(b);
        this.setAccessToken(null);
        this.setAccessExpires(0L);
        return response;
    }

    public String request(Bundle parameters) throws MalformedURLException, IOException {
        if (!parameters.containsKey("method")) {
            throw new IllegalArgumentException("API method must be specified. (parameters must contain key \"method\" and value). See http://developers.facebook.com/docs/reference/rest/");
        }
        return this.request(null, parameters, "GET");
    }

    public String request(String graphPath) throws MalformedURLException, IOException {
        return this.request(graphPath, new Bundle(), "GET");
    }

    public String request(String graphPath, Bundle parameters) throws MalformedURLException, IOException {
        return this.request(graphPath, parameters, "GET");
    }

    public String request(String graphPath, Bundle params, String httpMethod) throws FileNotFoundException, MalformedURLException, IOException {
        params.putString("format", "json");
        if (this.isSessionValid()) {
            params.putString(TOKEN, this.getAccessToken());
        }
        String url = graphPath != null ? GRAPH_BASE_URL + graphPath : RESTSERVER_URL;
        return Util.openUrl(url, httpMethod, params);
    }

    public void dialog(Context context, String action, DialogListener listener) {
        this.dialog(context, action, new Bundle(), listener);
    }

    public void dialog(Context context, String action, Bundle parameters, DialogListener listener) {
        boolean missingScreen = action.contentEquals("friends");
        String endpoint = missingScreen ? DIALOG_BASE_URL_FOR_MISSING_SCREENS : DIALOG_BASE_URL;
        endpoint = endpoint + action;
        parameters.putString("display", missingScreen ? "popup" : "touch");
        parameters.putString("redirect_uri", REDIRECT_URI);
        if (action.equals(LOGIN)) {
            parameters.putString("type", "user_agent");
            parameters.putString("client_id", this.mAppId);
        } else {
            parameters.putString("app_id", this.mAppId);
        }
        if (this.isSessionValid()) {
            parameters.putString(TOKEN, this.getAccessToken());
        }
        String url = endpoint + "?" + Util.encodeUrl(parameters);
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            Util.showAlert(context, "Error", "Application requires permission to access the Internet");
        } else {
            new FbDialog(context, url, listener).show();
        }
    }

    public boolean isSessionValid() {
        return this.getAccessToken() != null && (this.getAccessExpires() == 0L || System.currentTimeMillis() < this.getAccessExpires());
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public long getAccessExpires() {
        return this.mAccessExpires;
    }

    public void setAccessToken(String token) {
        this.mAccessToken = token;
        this.mLastAccessUpdate = System.currentTimeMillis();
    }

    public void setAccessExpires(long time) {
        this.mAccessExpires = time;
    }

    public void setAccessExpiresIn(String expiresIn) {
        if (expiresIn != null) {
            long expires = expiresIn.equals("0") ? 0L : System.currentTimeMillis() + Long.parseLong(expiresIn) * 1000L;
            this.setAccessExpires(expires);
        }
    }

    public String getAppId() {
        return this.mAppId;
    }

    public void setAppId(String appId) {
        this.mAppId = appId;
    }

    public static interface ServiceListener {
        public void onComplete(Bundle var1);

        public void onFacebookError(FacebookError var1);

        public void onError(Error var1);
    }

    public static interface DialogListener {
        public void onComplete(Bundle var1);

        public void onFacebookError(FacebookError var1);

        public void onError(DialogError var1);

        public void onCancel();
    }

    private class TokenRefreshServiceConnection
    implements ServiceConnection {
        final Messenger messageReceiver = new Messenger(new Handler(){

            public void handleMessage(Message msg) {
                String token = msg.getData().getString(Facebook.TOKEN);
                long expiresAt = msg.getData().getLong(Facebook.EXPIRES) * 1000L;
                Bundle resultBundle = (Bundle)msg.getData().clone();
                resultBundle.putLong(Facebook.EXPIRES, expiresAt);
                if (token != null) {
                    Facebook.this.setAccessToken(token);
                    Facebook.this.setAccessExpires(expiresAt);
                    if (TokenRefreshServiceConnection.this.serviceListener != null) {
                        TokenRefreshServiceConnection.this.serviceListener.onComplete(resultBundle);
                    }
                } else if (TokenRefreshServiceConnection.this.serviceListener != null) {
                    String error = msg.getData().getString("error");
                    if (msg.getData().containsKey("error_code")) {
                        int errorCode = msg.getData().getInt("error_code");
                        TokenRefreshServiceConnection.this.serviceListener.onFacebookError(new FacebookError(error, null, errorCode));
                    } else {
                        TokenRefreshServiceConnection.this.serviceListener.onError(new Error(error != null ? error : "Unknown service error"));
                    }
                }
                TokenRefreshServiceConnection.this.applicationsContext.unbindService((ServiceConnection)TokenRefreshServiceConnection.this);
            }
        });
        final ServiceListener serviceListener;
        final Context applicationsContext;
        Messenger messageSender = null;

        public TokenRefreshServiceConnection(Context applicationsContext, ServiceListener serviceListener) {
            this.applicationsContext = applicationsContext;
            this.serviceListener = serviceListener;
        }

        public void onServiceConnected(ComponentName className, IBinder service) {
            this.messageSender = new Messenger(service);
            this.refreshToken();
        }

        public void onServiceDisconnected(ComponentName arg) {
            this.serviceListener.onError(new Error("Service disconnected"));
            this.applicationsContext.unbindService((ServiceConnection)this);
        }

        private void refreshToken() {
            Bundle requestData = new Bundle();
            requestData.putString(Facebook.TOKEN, Facebook.this.mAccessToken);
            Message request = Message.obtain();
            request.setData(requestData);
            request.replyTo = this.messageReceiver;
            try {
                this.messageSender.send(request);
            }
            catch (RemoteException e) {
                this.serviceListener.onError(new Error("Service connection error"));
            }
        }
    }
}

