/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.testflightapp.acra.ACRA;
import com.testflightapp.acra.CrashReportPersister;
import com.testflightapp.acra.ReportField;
import com.testflightapp.acra.collector.CrashReportData;
import com.testflightapp.acra.util.ToastSender;
import java.io.IOException;

public class CrashReportDialog
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener {
    private static final String STATE_EMAIL = "email";
    private static final String STATE_COMMENT = "comment";
    private SharedPreferences prefs;
    private EditText userComment;
    private EditText userEmail;
    String mReportFileName;
    AlertDialog mDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean forceCancel = this.getIntent().getBooleanExtra("FORCE_CANCEL", false);
        if (forceCancel) {
            ACRA.log.d(ACRA.LOG_TAG, "Forced reports deletion.");
            this.cancelReports();
            this.finish();
            return;
        }
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        Log.d((String)ACRA.LOG_TAG, (String)("Opening CrashReportDialog for " + this.mReportFileName));
        if (this.mReportFileName == null) {
            this.finish();
        }
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        int resourceId = ACRA.getConfig().resDialogTitle();
        if (resourceId != 0) {
            dialogBuilder.setTitle(resourceId);
        }
        if ((resourceId = ACRA.getConfig().resDialogIcon()) != 0) {
            dialogBuilder.setIcon(resourceId);
        }
        dialogBuilder.setView(this.buildCustomView(savedInstanceState));
        dialogBuilder.setPositiveButton(17039370, (DialogInterface.OnClickListener)this);
        dialogBuilder.setNegativeButton(0x1040000, (DialogInterface.OnClickListener)this);
        this.cancelNotification();
        this.mDialog = dialogBuilder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        this.mDialog.show();
    }

    private View buildCustomView(Bundle savedInstanceState) {
        int emailPromptId;
        LinearLayout root = new LinearLayout((Context)this);
        root.setOrientation(1);
        root.setPadding(10, 10, 10, 10);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        root.setFocusable(true);
        root.setFocusableInTouchMode(true);
        ScrollView scroll = new ScrollView((Context)this);
        root.addView((View)scroll, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        LinearLayout scrollable = new LinearLayout((Context)this);
        scrollable.setOrientation(1);
        scroll.addView((View)scrollable);
        TextView text = new TextView((Context)this);
        int dialogTextId = ACRA.getConfig().resDialogText();
        if (dialogTextId != 0) {
            text.setText(this.getText(dialogTextId));
        }
        scrollable.addView((View)text);
        int commentPromptId = ACRA.getConfig().resDialogCommentPrompt();
        if (commentPromptId != 0) {
            String savedValue;
            TextView label = new TextView((Context)this);
            label.setText(this.getText(commentPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            scrollable.addView((View)label, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userComment = new EditText((Context)this);
            this.userComment.setLines(2);
            if (savedInstanceState != null && (savedValue = savedInstanceState.getString(STATE_COMMENT)) != null) {
                this.userComment.setText((CharSequence)savedValue);
            }
            scrollable.addView((View)this.userComment);
        }
        if ((emailPromptId = ACRA.getConfig().resDialogEmailPrompt()) != 0) {
            TextView label = new TextView((Context)this);
            label.setText(this.getText(emailPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            scrollable.addView((View)label);
            this.userEmail = new EditText((Context)this);
            this.userEmail.setSingleLine();
            this.userEmail.setInputType(33);
            this.prefs = this.getSharedPreferences(ACRA.getConfig().sharedPreferencesName(), ACRA.getConfig().sharedPreferencesMode());
            String savedValue = null;
            if (savedInstanceState != null) {
                savedValue = savedInstanceState.getString(STATE_EMAIL);
            }
            if (savedValue != null) {
                this.userEmail.setText((CharSequence)savedValue);
            } else {
                this.userEmail.setText((CharSequence)this.prefs.getString("acra.user.email", ""));
            }
            scrollable.addView((View)this.userEmail);
        }
        return root;
    }

    protected void cancelNotification() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(666);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.sendCrash();
        } else {
            this.cancelReports();
        }
        this.finish();
    }

    private void cancelReports() {
        ACRA.getErrorReporter().deletePendingNonApprovedReports(false);
    }

    private void sendCrash() {
        String usrEmail;
        String comment;
        String string = comment = this.userComment != null ? this.userComment.getText().toString() : "";
        if (this.prefs != null && this.userEmail != null) {
            usrEmail = this.userEmail.getText().toString();
            SharedPreferences.Editor prefEditor = this.prefs.edit();
            prefEditor.putString("acra.user.email", usrEmail);
            prefEditor.commit();
        } else {
            usrEmail = "";
        }
        CrashReportPersister persister = new CrashReportPersister(this.getApplicationContext());
        try {
            Log.d((String)ACRA.LOG_TAG, (String)("Add user comment to " + this.mReportFileName));
            CrashReportData crashData = persister.load(this.mReportFileName);
            crashData.put(ReportField.USER_COMMENT, comment);
            crashData.put(ReportField.USER_EMAIL, usrEmail);
            persister.store(crashData, this.mReportFileName);
        }
        catch (IOException e) {
            Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)e);
        }
        Log.v((String)ACRA.LOG_TAG, (String)"About to start SenderWorker from CrashReportDialog");
        ACRA.getErrorReporter().startSendingReports(false, true);
        int toastId = ACRA.getConfig().resDialogOkToast();
        if (toastId != 0) {
            ToastSender.sendToast(this.getApplicationContext(), toastId, 1);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.userComment != null && this.userComment.getText() != null) {
            outState.putString(STATE_COMMENT, this.userComment.getText().toString());
        }
        if (this.userEmail != null && this.userEmail.getText() != null) {
            outState.putString(STATE_EMAIL, this.userEmail.getText().toString());
        }
    }

    public void onDismiss(DialogInterface dialog) {
        this.finish();
    }
}

