/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils.images;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapScaler {
    private Bitmap scaled;

    public BitmapScaler(Resources resources, int resId, int newWidth) throws IOException {
        Size size = this.getRoughSize(resources, resId, newWidth);
        this.roughScaleImage(resources, resId, size);
        this.scaleImage(newWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapScaler(File file, int newWidth) throws IOException {
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            Size size = this.getRoughSize(is, newWidth);
            try {
                is = new FileInputStream(file);
                this.roughScaleImage(is, size);
                this.scaleImage(newWidth);
            }
            finally {
                is.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapScaler(AssetManager manager, String assetName, int newWidth) throws IOException {
        InputStream is = null;
        try {
            is = manager.open(assetName);
            Size size = this.getRoughSize(is, newWidth);
            try {
                is = manager.open(assetName);
                this.roughScaleImage(is, size);
                this.scaleImage(newWidth);
            }
            finally {
                is.close();
            }
        }
        finally {
            is.close();
        }
    }

    public BitmapScaler(Bitmap bitmap, int newWidth) {
        this.scaled = bitmap;
        this.scaleImage(newWidth);
    }

    public Bitmap getScaled() {
        return this.scaled;
    }

    private void scaleImage(int newWidth) {
        int width = this.scaled.getWidth();
        int height = this.scaled.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float ratio = (float)this.scaled.getWidth() / (float)newWidth;
        int newHeight = (int)((float)height / ratio);
        float scaleHeight = (float)newHeight / (float)height;
        if (height > width) {
            scaleHeight = (float)newWidth / (float)height;
            ratio = (float)this.scaled.getHeight() / (float)newWidth;
            newWidth = (int)((float)width / ratio);
            scaleWidth = (float)newWidth / (float)width;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        this.scaled = Bitmap.createBitmap((Bitmap)this.scaled, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    private void roughScaleImage(InputStream is, Size size) {
        Matrix matrix = new Matrix();
        matrix.postScale(size.scale, size.scale);
        BitmapFactory.Options scaledOpts = new BitmapFactory.Options();
        scaledOpts.inSampleSize = size.sample;
        this.scaled = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)scaledOpts);
    }

    private void roughScaleImage(Resources resources, int resId, Size size) {
        Matrix matrix = new Matrix();
        matrix.postScale(size.scale, size.scale);
        BitmapFactory.Options scaledOpts = new BitmapFactory.Options();
        scaledOpts.inSampleSize = size.sample;
        this.scaled = BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)scaledOpts);
    }

    private Size getRoughSize(InputStream is, int newWidth) {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)o);
        Size size = this.getRoughSize(o.outWidth, o.outHeight, newWidth);
        return size;
    }

    private Size getRoughSize(Resources resources, int resId, int newWidth) {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)o);
        Size size = this.getRoughSize(o.outWidth, o.outHeight, newWidth);
        return size;
    }

    private Size getRoughSize(int outWidth, int outHeight, int newWidth) {
        Size size = new Size();
        size.scale = outHeight > outWidth ? (float)(outHeight / newWidth) : (float)(outWidth / newWidth);
        size.sample = 1;
        int width = outWidth;
        int height = outHeight;
        int newHeight = (int)((float)outHeight / size.scale);
        while (width / 2 >= newWidth && height / 2 >= newHeight) {
            width /= 2;
            height /= 2;
            size.sample *= 2;
        }
        return size;
    }

    private static class Size {
        int sample;
        float scale;

        private Size() {
        }
    }
}

