/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.events;

import com.testflightapp.lib.TestFlight;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionEvent
implements Serializable {
    public static final String TYPE_SESSION_START = "session_start";
    public static final String TYPE_CHECKPOINT = "checkpoint";
    public static final String TYPE_CRASH = "crash";
    public static final String TYPE_SESSION_END = "session_end";
    private static final long serialVersionUID = -4203534711736815044L;
    protected static long sSessionStartEventTimeSeconds;
    protected final long mTimestampSeconds;
    protected final long mDuration;
    protected final String mType;
    protected final String mSessionID;
    protected long mPersistentId = -1L;
    protected long mBundleInfoPersistenceId = -1L;
    private static AtomicInteger sSeqNum;
    protected final int mSeqNum;

    public static void setSessionStartEventTimeToNow() {
        sSessionStartEventTimeSeconds = System.currentTimeMillis() / 1000L;
    }

    public SessionEvent(String string) {
        this(System.currentTimeMillis(), string);
    }

    protected SessionEvent(long l, String string) {
        this.mTimestampSeconds = l / 1000L;
        this.mDuration = this.mTimestampSeconds - sSessionStartEventTimeSeconds;
        this.mType = string;
        this.mSessionID = TestFlight.getSessionID();
        if (this.mType.equals(TYPE_SESSION_START)) {
            sSeqNum.set(0);
        }
        this.mSeqNum = sSeqNum.getAndIncrement();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("session_id", this.mSessionID);
        hashMap.put("type", this.mType);
        hashMap.put("timestamp", this.mTimestampSeconds);
        hashMap.put("duration", this.mDuration);
        hashMap.put("sequence_number", this.mSeqNum);
        return hashMap;
    }

    public void pack(Map<String, Object> map) {
        Object[] objectArray = new Object[]{this.toMap()};
        map.put("events", objectArray);
    }

    public static void packEvents(SessionEvent[] sessionEventArray, Map<String, Object> map) {
        Object[] objectArray = new Object[sessionEventArray.length];
        int n = sessionEventArray.length;
        for (int i = 0; i < n; ++i) {
            if (sessionEventArray[i] == null) {
                i = n;
                continue;
            }
            objectArray[i] = sessionEventArray[i].toMap();
        }
        map.put("events", objectArray);
    }

    public String toString() {
        return "SessionEvent [mSeqNum = " + this.mSeqNum + ",mTimestampSeconds=" + this.mTimestampSeconds + ", mDuration=" + this.mDuration + ", mType=" + this.mType + ", mSessionID=" + this.mSessionID + ", mPersistentId=" + this.mPersistentId + "]";
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    public long getPersistentId() {
        return this.mPersistentId;
    }

    public void setPersistentId(long l) {
        this.mPersistentId = l;
    }

    public long getBundleInfoPersistenceId() {
        return this.mBundleInfoPersistenceId;
    }

    public void setBundleInfoPersistenceId(long l) {
        this.mBundleInfoPersistenceId = l;
    }

    public String getType() {
        return this.mType;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.mPersistentId ^ this.mPersistentId >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SessionEvent sessionEvent = (SessionEvent)object;
        return this.mPersistentId == sessionEvent.mPersistentId;
    }

    static {
        sSeqNum = new AtomicInteger(0);
    }
}

