/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import android.os.Handler;
import android.os.Message;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class PausableHandler
extends Handler {
    private final Lock mLock = new ReentrantLock();
    private final Condition mPauseCondition = this.mLock.newCondition();
    private volatile boolean mPaused;

    PausableHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchMessage(Message message) {
        super.dispatchMessage(message);
        if (this.mPaused) {
            this.mLock.lock();
            try {
                while (this.mPaused) {
                    this.mPauseCondition.awaitUninterruptibly();
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    void pause() {
        this.mPaused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        if (this.mPaused) {
            this.mPaused = false;
            this.mLock.lock();
            try {
                this.mPauseCondition.signalAll();
            }
            finally {
                this.mLock.unlock();
            }
        }
    }
}

