/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.newapi;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.testflightapp.lib.core.newapi.Job;
import com.testflightapp.lib.core.newapi.PausableHandler;
import java.util.concurrent.locks.Lock;

class JobHandler
extends PausableHandler
implements Runnable {
    private final Lock mJobDispatcherLock;

    JobHandler(Lock lock) {
        this.mJobDispatcherLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        if (message.obj instanceof Job) {
            Job job = (Job)message.obj;
            job.run();
            long l = job.getRecurrentInterval();
            if (l != 0L) {
                this.mJobDispatcherLock.lock();
                try {
                    this.sendMessageDelayed(JobHandler.getMessage(this, job), l);
                }
                finally {
                    this.mJobDispatcherLock.unlock();
                }
            }
        }
    }

    static Message getMessage(Handler handler, Job job) {
        return Message.obtain((Handler)handler, (int)job.getJobId(), (Object)job);
    }

    @Override
    public void run() {
        Looper.myLooper().quit();
    }
}

