/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.networking.encoding;

import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.networking.encoding.IParameterEncoder;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.msgpack.MessagePack;
import org.msgpack.packer.BufferPacker;

public class MPParameterEncoder
implements IParameterEncoder {
    @Override
    public HttpEntity encode(Map<String, Object> map) {
        if (map == null) {
            Logger.e("null passed to MPParameterEncoder.encode");
            throw new NullPointerException("Cannot encode null parameters");
        }
        try {
            MessagePack messagePack = new MessagePack();
            BufferPacker bufferPacker = messagePack.createBufferPacker();
            this.packParameters(bufferPacker, map);
            return new ByteArrayEntity(bufferPacker.toByteArray());
        }
        catch (IOException iOException) {
            Logger.wtf("Unexpected error decoding data  (Possibly out of data):", iOException);
            throw new RuntimeException("Failed to pack parameters (Possibly out of data)", iOException);
        }
    }

    void packParameters(BufferPacker bufferPacker, Object object) throws IOException {
        if (object == null) {
            bufferPacker.writeNil();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            bufferPacker.writeMapBegin(map.entrySet().size());
            for (Map.Entry entry : map.entrySet()) {
                bufferPacker.write((String)entry.getKey());
                this.packParameters(bufferPacker, entry.getValue());
            }
            bufferPacker.writeMapEnd();
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            bufferPacker.writeArrayBegin(objectArray.length);
            for (Object object2 : objectArray) {
                this.packParameters(bufferPacker, object2);
            }
            bufferPacker.writeArrayEnd();
        } else if (object instanceof String || object instanceof Integer || object instanceof Float || object instanceof Boolean) {
            bufferPacker.write(object);
        } else if (object instanceof Double) {
            bufferPacker.write(((Double)object).floatValue());
        } else if (object instanceof Long) {
            bufferPacker.write(((Long)object).intValue());
        } else {
            String string = "Invalid parameter type " + object.getClass().toString() + " passed to MPParameterEncoder.encode";
            Logger.e(string);
            throw new RuntimeException(string);
        }
    }
}

