/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BundleInfo {
    private static String sBuildUUID = null;
    private static final String DEBUG_DN_CN = "cn=android debug";

    public static void pack(Context context, String string, Map<String, Object> map) {
        if (sBuildUUID == null) {
            BundleInfo.initBuildUUID(context);
        }
        String string2 = context.getPackageName();
        map.put("bundle_identifier", string2);
        map.put("application_token", string);
        map.put("uuid", sBuildUUID);
        try {
            String string3;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            map.put("beta", BundleInfo.wasSignedWithDebugCertificate(packageManager, string2));
            if (applicationInfo != null && packageManager != null) {
                try {
                    string3 = ((Object)packageManager.getApplicationLabel(applicationInfo)).toString();
                    map.put("app_name", string3);
                }
                catch (NullPointerException nullPointerException) {
                    Log.wtf((String)"Did fail to get app name", (Throwable)nullPointerException);
                    map.put("app_name", "");
                }
            } else {
                map.put("app_name", string2);
            }
            string3 = packageManager.getPackageInfo(string2, 0);
            map.put("app_version", ((PackageInfo)string3).versionName);
            map.put("app_version_number", ((PackageInfo)string3).versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private static void initBuildUUID(Context context) {
        Object object;
        Object object2;
        TreeMap treeMap = new TreeMap();
        try {
            object2 = context.getApplicationInfo().sourceDir;
            JarFile jarFile = new JarFile((String)object2);
            Manifest manifest = jarFile.getManifest();
            jarFile.close();
            Map<String, Attributes> object3 = manifest.getEntries();
            object = new Attributes.Name("SHA1-Digest");
            for (Map.Entry entry : object3.entrySet()) {
                Attributes attributes = (Attributes)entry.getValue();
                if (!attributes.containsKey(object)) continue;
                treeMap.put(entry.getKey(), attributes.getValue("SHA1-Digest"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (treeMap.size() == 0) {
            sBuildUUID = "";
        } else {
            object2 = new byte[16];
            int n = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                for (Object object3 : object = (Object)Base64.decode((String)((String)entry.getValue()), (int)0)) {
                    object2[n] = (byte)(object2[n] ^ object3);
                    n = (n + 1) % 16;
                }
            }
            sBuildUUID = BundleInfo.convertBytesToUUID((byte[])object2, false);
        }
    }

    private static String convertBytesToUUID(byte[] byArray, boolean bl) {
        String string = "";
        for (int i = 0; i < 16; ++i) {
            string = string + String.format("%02x", byArray[i]);
            if (!bl || i != 3 && i != 5 && i != 7 && i != 9) continue;
            string = string + '-';
        }
        return string;
    }

    private static boolean wasSignedWithDebugCertificate(PackageManager packageManager, String string) {
        try {
            Signature signature = packageManager.getPackageInfo((String)string, (int)64).signatures[0];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
            return x509Certificate.getIssuerDN().getName().toLowerCase(Locale.US).startsWith(DEBUG_DN_CN);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

