/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;

class JStylerObj {
    JStylerObj() {
    }

    public static boolean isSpace(char c) {
        return c == '\r' || c == '\n' || c == '\t' || c == ' ';
    }

    public static boolean isSpecialChar(char c) {
        return c == '\b' || c == '\f' || c == '\n';
    }

    public static boolean isSpecialOpen(char c) {
        return c == '{' || c == '[' || c == ',' || c == ':';
    }

    public static boolean isSpecialClose(char c) {
        return c == '}' || c == ']' || c == ',' || c == ':';
    }

    public static boolean isSpecial(char c) {
        return c == '{' || c == '[' || c == ',' || c == '}' || c == ']' || c == ':' || c == '\'' || c == '\"';
    }

    public static boolean isUnicode(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff';
    }

    public static boolean isKeyword(String s) {
        if (s.length() < 3) {
            return false;
        }
        char c = s.charAt(0);
        if (c == 'n') {
            return s.equals("null");
        }
        if (c == 't') {
            return s.equals("true");
        }
        if (c == 'f') {
            return s.equals("false");
        }
        if (c == 'N') {
            return s.equals("NaN");
        }
        return false;
    }

    public static void escape(String s, Appendable sb) {
        try {
            int len = s.length();
            block12: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block12;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block12;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block12;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block12;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block12;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block12;
                    }
                    case '/': {
                        sb.append("\\/");
                        continue block12;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            sb.append("\\u");
                            String hex = "0123456789ABCDEF";
                            sb.append(hex.charAt(ch >> 12 & 0xF));
                            sb.append(hex.charAt(ch >> 8 & 0xF));
                            sb.append(hex.charAt(ch >> 4 & 0xF));
                            sb.append(hex.charAt(ch >> 0 & 0xF));
                            continue block12;
                        }
                        sb.append(ch);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible Error");
        }
    }
}

