/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;

public class JSONObject
extends HashMap<String, Object>
implements JSONAware {
    private static final long serialVersionUID = -503443796854799292L;

    public JSONObject() {
    }

    public <T> T cast() {
        return (T)this;
    }

    public static String escape(String s) {
        return JSONValue.escape(s);
    }

    public static String toJSONString(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject.writeJSONString(map, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    private static void toJSONString(String key, Object value, Appendable out) throws IOException {
        if (key == null) {
            out.append("null");
        } else {
            out.append('\"');
            JSONValue.escape(key, out);
            out.append('\"');
        }
        out.append(':');
        if (value instanceof String) {
            out.append('\"');
            JSONValue.escape((String)value, out);
            out.append('\"');
        } else {
            JSONValue.writeJSONString(value, out);
        }
    }

    public static String toString(String key, Object value) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject.toJSONString(key, value, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public JSONObject(Map<String, ?> map) {
        super(map);
    }

    public static void writeJSONString(Map<String, Object> map, Appendable out) throws IOException {
        if (map == null) {
            out.append("null");
            return;
        }
        boolean first = true;
        out.append('{');
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            JSONObject.toJSONString(entry.getKey(), entry.getValue(), out);
        }
        out.append('}');
    }

    public void writeJSONString(Appendable out) throws IOException {
        JSONObject.writeJSONString(this, out);
    }

    public void merge(Object o2) {
        JSONObject.merge(this, o2);
    }

    protected static JSONObject merge(JSONObject o1, Object o2) {
        if (o2 == null) {
            return o1;
        }
        if (o2 instanceof JSONObject) {
            return JSONObject.merge(o1, (JSONObject)o2);
        }
        throw new RuntimeException("JSON megre can not merge a JSONObject with " + o2.getClass());
    }

    private static JSONObject merge(JSONObject o1, JSONObject o2) {
        if (o2 == null) {
            return o1;
        }
        for (String key : o1.keySet()) {
            Object value1 = o1.get(key);
            Object value2 = o2.get(key);
            if (value2 == null) continue;
            if (value1 instanceof JSONArray) {
                o1.put(key, JSONObject.merge((JSONArray)value1, value2));
                continue;
            }
            if (value1 instanceof JSONObject) {
                o1.put(key, JSONObject.merge((JSONObject)value1, value2));
                continue;
            }
            throw new RuntimeException("JSON megre can not merge a " + value1.getClass() + " with " + value2.getClass());
        }
        for (String key : o2.keySet()) {
            if (o1.containsKey(key)) continue;
            o1.put(key, o2.get(key));
        }
        return o1;
    }

    protected static JSONArray merge(JSONArray o1, Object o2) {
        if (o2 == null) {
            return o1;
        }
        if (o1 instanceof JSONArray) {
            return JSONObject.merge(o1, (JSONArray)o2);
        }
        o1.add(o2);
        return o1;
    }

    private static JSONArray merge(JSONArray o1, JSONArray o2) {
        o1.addAll(o2);
        return o1;
    }

    @Override
    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }
}

