/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.StorageManager;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public final class Base64Uploader {
    public static State save(String content, Map<String, Object> conf) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        String savePath = PathFormat.parse((String)conf.get("savePath"), (String)conf.get("filename"));
        if (savePath != null && (savePath.contains("../") || savePath.contains("..\\"))) {
            return new BaseState(false, 6);
        }
        savePath = savePath + suffix;
        String physicalPath = (String)conf.get("rootPath") + savePath;
        State storageState = StorageManager.saveBinaryFile(data, physicalPath);
        if (storageState.isSuccess()) {
            storageState.putInfo("url", PathFormat.format(savePath));
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", "");
        }
        return storageState;
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

