<!DOCTYPE html>
<html>
<head>
	<title>自定义表单数据列表</title>
	<#include "../../include/head-file.ftl">
</head>
<body>
<div id="index" v-cloak >
	<div  class="ms-index">
		<ms-search ref="search" @search="search" :condition-data="conditionList" :conditions="conditions"></ms-search>
		<el-header class="ms-header" height="50px">
			<el-col :span=12>
				<el-button type="primary" icon="el-icon-plus" size="mini" @click="save()">新增</el-button>
				<el-button type="danger" icon="el-icon-delete" size="mini" @click="del(selectionList)"  :disabled="!selectionList.length">删除</el-button>
			</el-col>
			<!-- 菜单点击到当前页面就没有返回按钮-->
			<el-col :span=12 class="ms-tr" >
				<el-button type="primary" icon="iconfont icon-shaixuan1" size="mini" @click="currentPage=1;$refs.search.open()">筛选</el-button>
				<el-button size="mini"   plain onclick="javascript:history.go(-1)"><i class="iconfont icon-fanhui"></i>返回</el-button>
			</el-col>
		</el-header>
		<el-main class="ms-container">
			<el-table v-loading="loading" ref="multipleTable" height="calc(100vh-68px)" class="ms-table-pagination" border :data="dataList" tooltip-effect="dark" @selection-change="handleSelectionChange">
				<template slot="empty">
					<el-empty :description="emptyText"></el-empty>
				</template>
				<el-table-column type="selection" width="40"></el-table-column>

				<div v-if="field.isShow == 'true'" v-for="(field,index) in tableField">
					<el-table-column  min-width="100"  :label="field.name" :prop="field.key" v-if="field.type == 'input' ">
					</el-table-column>
					<el-table-column min-width="100" :label="field.name" :prop="field.key" v-else-if=" field.type == 'number' ">
					</el-table-column>
					<el-table-column min-width="100" :label="field.name" :prop="field.key" v-else-if=" field.type == 'money' " :formatter="$table.moneyFormatter">
					</el-table-column>
					<el-table-column min-width="120" :label="field.name" :prop="field.key" v-else-if="field.type == 'select' || field.type == 'radio' || field.type == 'checkbox' "  :formatter="fmt">
					</el-table-column>
					<el-table-column min-width="190" width="200" align="center" :label="field.name" :prop="field.key" v-else-if="field.type == 'date' || field.type == 'time'">
						<el-table-column min-width="190" width="200" align="center" :label="field.name" :prop="field.key" v-else-if="field.type == 'date'">

							<template slot-scope="scope">
								<span v-if="field.javaType=='String'" v-text="scope.row[field.key]"></span>
								<span v-else-if="field.endModel" v-html="ms.util.date.fmt(scope.row[field.key],field.fmt)+'-'+ms.util.date.fmt(scope.row[field.endModel],field.fmt)"></span>
								<span v-else-if="field.fmt" v-text="ms.util.date.fmt(scope.row[field.key],field.fmt)"></span> <!--排除范围-->
								<span v-else v-text="ms.util.date.fmt(scope.row[field.key],'yyyy-MM-dd')"></span>
							</template>

						</el-table-column>
						<el-table-column min-width="190" width="200" align="center" :label="field.name" :prop="field.key" v-else-if="field.type == 'time'">

							<template slot-scope="scope">
								<span v-if="field.endModel" v-html="moment(scope.row[field.key],field.fmt).format(field.fmt)+'-'+moment(scope.row[field.endModel],field.fmt).format(field.fmt)"></span>
								<span v-else-if="field.fmt" v-text="moment(scope.row[field.key],field.fmt).format(field.fmt)"></span> <!--排除范围-->
								<span v-else v-text="moment(scope.row[field.key],'HH:mm:ss').format('HH:mm:ss')"></span>
							</template>

						</el-table-column>
						<el-table-column min-width="120" width="200" align="center" :label="field.name" :prop="field.key" v-else-if="field.type == 'time' ">
							<template slot-scope="scope">
								<span v-if="field.endModel" v-html="scope.row[field.key]+'<br/>'+scope.row[field.endModel]"></span>
								<span v-else v-text="scope.row[field.key]"></span>
							</template>
						</el-table-column>
						<el-table-column min-width="120" :label="field.name" align="left" :prop="field.key" v-else-if="field.type == 'imgupload' ">
							<template slot-scope="scope"  v-if="scope.row[field.key]">
								<div class="block"  v-for="src in scope.row[field.key]">
									<el-image
											style="width: 50px; height: 50px;float: left;margin-right: 5px;"
											:src="ms.base+src.path"
											:preview-src-list="[ms.base+src.path]">
									</el-image>
								</div>
							</template>
						</el-table-column>

				</div>
				<el-table-column label="操作" align="center" width="200" >
					<template slot-scope="scope">
						<el-link type="primary" :underline="false" @click="save(scope.row.id)">编辑</el-link>
						<el-link type="primary" :underline="false"  @click="del(scope.row)">删除</el-link>
					</template>
				</el-table-column>
			</el-table>
			<el-pagination
					background
					:page-sizes="[5, 10, 20, 50, 100]"
					layout="total, sizes, prev, pager, next, jumper"
					:current-page="currentPage"
					:page-size="pageSize"
					:total="total"
					class="ms-pagination"
					@current-change='currentChange'
					@size-change="sizeChange">
			</el-pagination>
		</el-main>
	</div>

</div>

</body>
</html>
<script>
	var indexVue = new Vue({
		el: '#index',
		data: function () {
			return {
				loading: true,//加载状态
				conditionList:null,
				conditions:[],
				modelId: null,
				modelName: '',
				tableField: [],
				dataList: [],
				//自定义模型列表
				selectionList: [],
				//自定义模型列表选中
				total: 0,
				//总记录数量
				pageSize: 50,
				//页面数量
				currentPage: 1,
				//初始页
				mananger: ms.manager,
				emptyText: '',
				form: {},
			}
		},
		watch: {
		},
		methods: {
			fmt:function(row, column, cellValue, index) {
				var fieldFmt = searchJson.filter(item => item.field.toLowerCase()==column.property.toLowerCase())
				if(fieldFmt.length>0){
					return eval('this.'+fieldFmt[0].model+'Format').call(null,row, column, cellValue, index);
				}else {
					return cellValue;
				}
			},
			//新增
			save: function (id) {
				if (id) {
					// location.href = this.mananger + "/mdiy/formData/form.do?id=" + id+"&modelName="+this.modelName;
					ms.util.openSystemUrl("/mdiy/form/data/form.do?id=" + id+"&modelName="+this.modelName);
				} else {
					// location.href = this.mananger + "/mdiy/formData/form.do?modelName="+this.modelName;
					ms.util.openSystemUrl("/mdiy/form/data/form.do?modelName="+this.modelName);
				}
			},
			//获取表格字段
			getTableField: function () {
				var that = this;
				ms.http.get(ms.manager + "/mdiy/form/get.do",{modelName:this.modelName}).then(function (res) {
					if(res.result){
						//得到的内容为json字符串，需要转对象
						//创建时间
						var createDate = {
							"model": "createDate",
							"key": "create_date",
							"field": "CREATE_DATE",
							"javaType": "date",
							"jdbcType": "date",
							"name": "创建时间",
							"type": "date",
							"isShow": "true"
						}
						that.tableField = JSON.parse(res.data.modelField);
						that.tableField.push(createDate);
						that.tableField.forEach(function (item) {
							item.key = item.key.toLowerCase();
						})

					}else {
						that.$notify({
							title: '失败',
							message: res.msg,
							type: 'warning'
						});
					}
				});
			},

			// 小写转换
			lowerJSONKey: function (jsonObj){
				for (var key in jsonObj){
					jsonObj[key.toLowerCase()] = jsonObj[key];
					//排除小写字段 如：id
					if(key.toLowerCase()!=key) {
						delete(jsonObj[key]);
					}
				}
				return jsonObj;
			},
			//查询列表
			list: function (isSearch) {
				var that = this;
				var data = null; //搜索参数
				that.loading = true;
				var page={
					pageNo: that.currentPage,
					pageSize : that.pageSize
				}
				var form = JSON.parse(JSON.stringify(that.form))


				if(isSearch) {
					//删除空字符串
					for (var key in form){
						if(form[key] === undefined || form[key] === null){
							delete  form[key]
						}
					}
					form.sqlWhere ? data = Object.assign({modelId:that.modelId}, {sqlWhere: form.sqlWhere}, page) : data = Object.assign({modelId:that.modelId}, form, page)
				} else {
					data = Object.assign( {modelId:that.modelId}, page);
				}

				history.replaceState({form:form,page:page},"");
				ms.http.post(ms.manager + "/mdiy/form/data/queryData.do",data).then(function (data) {
					if (data.result){
						data = data.data;
						if (data.total <= 0) {
							that.emptyText = '暂无数据';
							that.dataList = [];
						} else {
							that.total = data.total;
							data.rows.forEach(function (item) {
								item = that.lowerJSONKey(item);
								Object.keys(item).forEach(function (field) {
									field = field.toLowerCase()
									try {
										if (item[field] != "" && JSON.parse(item[field]).length > 0) {
											var picture = [];
											JSON.parse(item[field]).forEach(function (img) {
												picture.push(img);
											});
											item[field] = picture;
										}
									} catch (e) {
										console.log(e);
									}
								});
							});
							that.dataList = data.rows;
						}
						that.$nextTick(function(){
							that.$refs.multipleTable.doLayout();
						})
					}else {
						that.$notify({
							title: '失败',
							message: data.msg,
							type: 'warning'
						});
					}
					that.loading = false;
				});
			},
			//自定义模型列表选中
			handleSelectionChange: function (val) {
				this.selectionList = val;
			},
			//删除
			del: function (row) {
				var that = this;
				var ids = [];
				if (row.length > 0) {
					row.forEach(function (item, index) {
						ids.push(item.id);
					});
				} else {
					ids.push(row.id);
				}
				that.$confirm('此操作将永久删除所选内容, 是否继续?', '提示', {
					confirmButtonText: '确定',
					cancelButtonText: '取消',
					type: 'warning'
				}).then(function () {
					ms.http.post(ms.manager + "/mdiy/form/data/delete.do", {
						modelId: that.modelId,
						ids: ids.join(',')
					}).then(function (data) {
						if (data.result) {
							that.$notify({
								title: '成功',
								type: 'success',
								message: '删除成功!'
							}); //删除成功，刷新列表

							that.list();
						} else {
							that.$notify({
								title: '失败',
								message: data.msg,
								type: 'warning'
							});
						}
					});
				});
			},
			//pageSize改变时会触发
			sizeChange: function (pagesize) {
				this.loading = true;
				this.pageSize = pagesize;
				this.list();
			},
			search:function(data){
				this.form.sqlWhere = JSON.stringify(data);
				this.list(true);
			},
			//currentPage改变时会触发
			currentChange: function (currentPage) {
				this.loading = true;
				this.currentPage = currentPage;
				this.list();
			},
			get: function() {
			},
			async render(modelName){
				var that = this;

				await ms.http.get(ms.manager + "/mdiy/form/get.do", {modelName:modelName}).then(function (res) {
					if (res.result && res.data) {
						that.modelId = res.data.id;
						var data = JSON.parse(res.data.modelJson);
						that.conditionList = eval(data.searchJson);
					}
				});

			}
		},
		created: function () {
			this.render(this.modelName);
			this.modelName = ms.util.getParameter("modelName");
			this.modelId = ms.util.getParameter("modelId");
			this.getTableField();
			this.list();

		}
	});
</script>
<style>
	#index .iconfont{
		font-size: 12px;
		margin-right: 5px;
	}
</style>


