/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.biz.ITagBiz;
import net.mingsoft.mdiy.constant.e.TagTypeEnum;
import net.mingsoft.mdiy.entity.TagEntity;
import net.mingsoft.mdiy.tag.CustomTag;
import net.mingsoft.mdiy.tag.IncludeExTag;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class ParserUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(ParserUtil.class);
    public static final String SHORT_SWITCH = "shortSwitch";
    public static final String HTML = "html";
    public static final String INDEX = "index";
    public static final String HTML_SUFFIX = ".html";
    public static final String TAG_PREFIX = "ms_";
    public static final String PAGE_LIST = "list-";
    public static final String HTM_SUFFIX = ".htm";
    public static final String IS_DO = "isDo";
    public static final String URL = "url";
    public static final String COLUMN = "column";
    public static final String ID = "id";
    public static final String FIELD = "field";
    public static final String TABLE_NAME = "tableName";
    public static final String MODEL_NAME = "modelName";
    public static final String PAGE = "pageTag";
    public static final String TYPE_ID = "typeid";
    public static final String APP_ID = "appId";
    public static final String APP_DIR = "appDir";
    public static Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
    public static FileTemplateLoader ftl = null;
    public static StringTemplateLoader stringLoader;
    public static List<String> systemTag1;
    public static final Lock LOCK;
    public static final String CONTEXT_PATH = "contextPath";

    public static String buildTemplatePath() {
        return ParserUtil.buildTemplatePath(null);
    }

    public static String buildTemplatePath(String path) {
        return ParserUtil.buildTemplatePath(null, path);
    }

    public static String buildTemplatePath(String style, String path) {
        String uploadTemplatePath = MSProperties.upload.template;
        if (BasicUtil.getWebsiteApp() != null) {
            return BasicUtil.getRealPath((String)(uploadTemplatePath + File.separator + BasicUtil.getWebsiteApp().getAppId() + File.separator + (style != null ? File.separator + style : BasicUtil.getWebsiteApp().getAppStyle()) + (path != null ? File.separator + path : "")));
        }
        return BasicUtil.getRealPath((String)(uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId() + File.separator + (style != null ? File.separator + style : BasicUtil.getApp().getAppStyle()) + (path != null ? File.separator + path : "")));
    }

    public static String buildHtmlPath(String path, String htmlDir, String appDir) {
        return BasicUtil.getRealPath((String)htmlDir) + File.separator + appDir + File.separator + path + HTML_SUFFIX;
    }

    public static String rendering(Map root, String content) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_0);
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate("template", content);
        cfg.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
        cfg.setNumberFormat("#");
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        Template template = cfg.getTemplate("template", "utf-8");
        StringWriter writer = new StringWriter();
        template.process((Object)root, (Writer)writer);
        return writer.toString();
    }

    public static int getPageSize(String templatePath, int defaultSize) {
        String buildTempletPath = ParserUtil.buildTemplatePath();
        String content = FileUtil.readString((File)FileUtil.file((String)buildTempletPath, (String)templatePath), (Charset)CharsetUtil.CHARSET_UTF_8);
        Pattern pattern = Pattern.compile("\\{(.*?)ispaging=true(.*?)\\}");
        Matcher m = pattern.matcher(content);
        String size = null;
        if (m.find()) {
            size = ReUtil.extractMulti((String)"size=(\\d*)", (CharSequence)m.group(1), (String)"$1");
            if (size == null) {
                size = ReUtil.extractMulti((String)"size=(\\d*)", (CharSequence)m.group(2), (String)"$1");
            }
            if (size != null) {
                defaultSize = Integer.parseInt(size);
            }
            LOG.debug("\u83b7\u53d6\u5206\u9875\u7684size:{}", (Object)size);
        }
        return defaultSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String rendering(String templatePath, Map map) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        LOCK.lock();
        try {
            String buildTempletPath = ParserUtil.buildTemplatePath();
            ITagBiz tagBiz = (ITagBiz)SpringUtil.getBean(ITagBiz.class);
            List list = tagBiz.list();
            if (ftl == null || !buildTempletPath.equals(ParserUtil.ftl.baseDir.getPath())) {
                stringLoader = new StringTemplateLoader();
                ftl = new FileTemplateLoader(new File(buildTempletPath));
                MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(new TemplateLoader[]{stringLoader, ftl});
                cfg.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
                cfg.setNumberFormat("#");
                cfg.setTemplateLoader((TemplateLoader)multiTemplateLoader);
                ClassPathResource classPathResource = new ClassPathResource("WEB-INF/macro.ftl");
                String template = IOUtils.toString((InputStream)classPathResource.getInputStream(), (String)"UTF-8");
                StringBuffer sb = new StringBuffer(template);
                list.forEach(tag -> {
                    TagTypeEnum typeEnum = TagTypeEnum.get(tag.getTagType());
                    if (typeEnum == TagTypeEnum.MACRO) {
                        sb.append(tag.getTagSql());
                    }
                });
                stringLoader.putTemplate("macro.ms", sb.toString());
                cfg.setClassicCompatible(true);
                cfg.addAutoInclude("macro.ms");
            }
            String temp = FileUtil.readString((File)FileUtil.file((String)buildTempletPath, (String)templatePath), (Charset)CharsetUtil.CHARSET_UTF_8);
            Template template = null;
            temp = ParserUtil.replaceTag(temp);
            stringLoader.putTemplate("ms:custom:" + templatePath, temp);
            try {
                template = cfg.getTemplate("ms:custom:" + templatePath, "utf-8");
            }
            catch (Exception e) {
                LOG.debug("\u6a21\u677f\u9519\u8bef");
                e.printStackTrace();
                LOG.debug(temp);
            }
            cfg.setClassicCompatible(true);
            cfg.setSharedVariable("ms_includeEx", (TemplateModel)new IncludeExTag(buildTempletPath, stringLoader));
            list.forEach(tag -> {
                if (StrUtil.isNotBlank((CharSequence)tag.getTagName())) {
                    TagTypeEnum typeEnum = TagTypeEnum.get(tag.getTagType());
                    if (typeEnum == TagTypeEnum.LIST) {
                        cfg.setSharedVariable(TAG_PREFIX + tag.getTagName(), (TemplateModel)new CustomTag(map, (TagEntity)((Object)tag)));
                    }
                    if (typeEnum == TagTypeEnum.SINGLE && (!systemTag1.contains(tag.getTagName()) || map.containsKey(ID) && tag.getTagName().equals(FIELD) || map.containsKey(PAGE) && (tag.getTagName().equals("pre") || tag.getTagName().equals("next") || tag.getTagName().equals("page")))) {
                        String sql = null;
                        try {
                            sql = ParserUtil.rendering(map, tag.getTagSql());
                            List _list = (List)tagBiz.excuteSql(sql);
                            if (_list.size() > 0) {
                                if (_list.get(0) != null) {
                                    MapWrapper mw = new MapWrapper((Map)((HashMap)_list.get(0)));
                                    mw.forEach(x -> {
                                        if (x.getValue() instanceof Clob) {
                                            x.setValue(StringUtil.clobStr((Clob)((Clob)x.getValue())));
                                        }
                                    });
                                }
                                map.put(tag.getTagName(), _list.get(0));
                            }
                        }
                        catch (IOException e) {
                            LOG.error("", (Throwable)e);
                        }
                        catch (TemplateException e) {
                            LOG.error("", (Throwable)e);
                        }
                    }
                }
            });
            StringWriter writer = new StringWriter();
            template.process((Object)map, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            LOG.error("\u6e32\u67d3\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
        return null;
    }

    public static String replaceTag(String content) {
        content = content.replaceAll("<#include(.*)/>", StrUtil.format((CharSequence)"<@{}includeEx template=$1/>", (Object[])new Object[]{TAG_PREFIX}));
        content = content.replaceAll("<#include(.*)>", StrUtil.format((CharSequence)"<@{}includeEx template=$1/>", (Object[])new Object[]{TAG_PREFIX}));
        content = content.replaceAll("\\{ms:([^\\}]+)/\\}", "\\${$1}");
        content = content.replaceAll("\\{@ms:([^\\}]+)/\\}", StrUtil.format((CharSequence)"<@{}$1/>", (Object[])new Object[]{TAG_PREFIX}));
        content = content.replaceAll("\\{ms:([^\\}]+)\\}", StrUtil.format((CharSequence)"<@{}$1>", (Object[])new Object[]{TAG_PREFIX}));
        content = content.replaceAll("\\{/ms:([^\\}]+)\\}", StrUtil.format((CharSequence)"</@{}$1>", (Object[])new Object[]{TAG_PREFIX}));
        content = content.replaceAll("\\[([^\\]]+)/\\]", "\\${$1}");
        return content;
    }

    static {
        systemTag1 = CollUtil.toList((Object[])new String[]{FIELD, "pre", "page", "next"});
        LOCK = new ReentrantLock();
    }
}

