/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.IModelDataBiz;
import net.mingsoft.mdiy.constant.e.ModelCustomTypeEnum;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u81ea\u5b9a\u4e49\u6a21\u5757\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/form/data"})
public class FormDataAction
extends BaseAction {
    @Autowired
    private IModelDataBiz modelDataBiz;
    @Autowired
    private IModelBiz modelBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        String modelName = BasicUtil.getString((String)"modelName");
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ModelEntity::getModelName, (Object)modelName)).eq(ModelEntity::getModelCustomType, (Object)ModelCustomTypeEnum.FORM.getLabel())));
        if (modelEntity == null) {
            throw new BusinessException(this.getResString("err.not.exist", new String[]{this.getResString("model")}));
        }
        return "/mdiy/form/data/index";
    }

    @ApiIgnore
    @GetMapping(value={"/form"})
    public String form(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        String businessForm = BasicUtil.getString((String)"businessUrl");
        if (StringUtils.isNotBlank((CharSequence)businessForm)) {
            return businessForm;
        }
        return "/mdiy/form/data/form";
    }

    @ApiOperation(value="\u63d0\u4f9b\u540e\u53f0\u67e5\u8be2\u81ea\u5b9a\u4e49\u8868\u5355\u63d0\u4ea4\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u578b\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query")})
    @RequestMapping(value={"/queryData"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData queryData(HttpServletRequest request, HttpServletResponse response) {
        Map map = BasicUtil.assemblyRequestMap();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getId, map.get("modelId"))).or()).eq(ModelEntity::getModelName, map.get("modelName"));
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)wrapper, false));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        if (!this.getPermissions("mdiy:formData:view", "mdiy:formData:" + modelEntity.getModelName() + ":view")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        map.putIfAbsent("order", "desc");
        map.putIfAbsent("orderBy", "id");
        List list = this.modelDataBiz.queryDiyFormData(modelEntity.getId(), map);
        return ResultData.build().success((Object)new EUListBean(list, (int)BasicUtil.endPage((List)list).getTotal()));
    }

    @ApiOperation(value="\u63d0\u4f9b\u540e\u53f0\u67e5\u8be2\u81ea\u5b9a\u4e49\u8868\u5355\u63d0\u4ea4\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u578b\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query")})
    @GetMapping(value={"/getData"})
    @ResponseBody
    public ResultData getData(HttpServletRequest request, HttpServletResponse response) {
        String modelId = BasicUtil.getString((String)"modelId");
        String modelName = BasicUtil.getString((String)"modelName");
        String id = BasicUtil.getString((String)"id");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getId, (Object)modelId)).or()).eq(ModelEntity::getModelName, (Object)modelName);
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)wrapper, false));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        if (StringUtils.isEmpty((CharSequence)id)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        Object object = this.modelDataBiz.getFormData(modelEntity.getId(), id);
        if (ObjectUtil.isNotNull((Object)object)) {
            return ResultData.build().success(object);
        }
        return ResultData.build().error();
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u4e1a\u52a1\u6a21\u578b\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="modelId", value="\u4e1a\u52a1\u6a21\u578bId", required=false, paramType="query")})
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"save"})
    @ResponseBody
    public ResultData save(HttpServletRequest request, HttpServletResponse response) {
        Map map = BasicUtil.assemblyRequestMap();
        CaseInsensitiveMap caseIgnoreMap = new CaseInsensitiveMap(map);
        String modelName = BasicUtil.getString((String)"modelName");
        String modelId = BasicUtil.getString((String)"modelId");
        if (StringUtils.isBlank((CharSequence)modelName) && StringUtils.isBlank((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(StringUtils.isNotEmpty((CharSequence)modelName), ModelEntity::getModelName, (Object)modelName)).eq(StringUtils.isNotEmpty((CharSequence)modelId), BaseEntity::getId, (Object)modelId)).eq(ModelEntity::getModelCustomType, (Object)ModelCustomTypeEnum.FORM.getLabel());
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getOne((Wrapper)wrapper, true));
        if (modelEntity == null) {
            return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("model.name")}));
        }
        if (!this.getPermissions("mdiy:formData:save", "mdiy:formData:" + modelEntity.getModelName() + ":save")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        if (this.modelDataBiz.saveDiyFormData(modelEntity.getId(), (Map<String, Object>)caseIgnoreMap)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
    }

    @ApiOperation(value="\u66f4\u65b0\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e")
    @ApiImplicitParam(name="modelId", value="\u6a21\u578b\u7f16\u53f7", required=true, paramType="query")
    @LogAnn(title="\u66f4\u65b0\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"update"})
    @ResponseBody
    public ResultData update(HttpServletRequest request, HttpServletResponse response) {
        Map map = BasicUtil.assemblyRequestMap();
        CaseInsensitiveMap caseIgnoreMap = new CaseInsensitiveMap(map);
        String modelId = caseIgnoreMap.get((Object)"modelId").toString();
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (!this.getPermissions("mdiy:formData:update", "mdiy:formData:" + modelEntity.getModelName() + ":update")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        if (this.modelDataBiz.updateDiyFormData(modelId, (Map<String, Object>)caseIgnoreMap)) {
            return ResultData.build().success();
        }
        return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e\u63a5\u53e3")
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u4e1a\u52a1\u6570\u636e\u63a5\u53e3", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"delete"})
    @ResponseBody
    public ResultData delete(@RequestParam(value="modelId") String modelId, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts((String)"ids", (String)",");
        if (ids == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.id")}));
        }
        ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelId)));
        if (!this.getPermissions("mdiy:formData:del", "mdiy:formData:" + modelEntity.getModelName() + ":del")) {
            return ResultData.build().error("\u6ca1\u6709\u6743\u9650!");
        }
        for (int id : ids) {
            this.modelDataBiz.deleteQueryDiyFormData(id, modelId);
        }
        return ResultData.build().success();
    }
}

