/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.aop;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.aop.FileVerifyAop;
import net.mingsoft.basic.bean.UploadConfigBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.FileUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.cms.bean.EditorStateBean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
public class EditorFileVerifyAop
extends FileVerifyAop {
    @Pointcut
    public void uploadPointCut() {
    }

    @Around(value="execution(* net.mingsoft.cms.action.EditorAction.editor(..)) ")
    public Object uploadAop(ProceedingJoinPoint joinPoint) throws Throwable {
        String action = BasicUtil.getString((String)"action");
        if (StrUtil.isBlank((CharSequence)action) || "config".equals(action)) {
            return joinPoint.proceed();
        }
        List<MultipartFile> files = this.getFiles(joinPoint);
        UploadConfigBean bean = new UploadConfigBean();
        for (MultipartFile multipartFile : files) {
            bean = new UploadConfigBean();
            bean.setFile(multipartFile);
            ResultData resultData = this.prepareUpload(bean, false);
            if (resultData.isSuccess()) continue;
            return new EditorStateBean(false, resultData.getMsg()).toString();
        }
        return joinPoint.proceed();
    }

    @Around(value="execution(* net.mingsoft.cms.action.web.EditorAction.editor(..))")
    public Object webUploadAop(ProceedingJoinPoint joinPoint) throws Throwable {
        String action = BasicUtil.getString((String)"action");
        if (StrUtil.isBlank((CharSequence)action) || "config".equals(action)) {
            return joinPoint.proceed();
        }
        List<MultipartFile> files = this.getFiles(joinPoint);
        UploadConfigBean bean = new UploadConfigBean();
        for (MultipartFile multipartFile : files) {
            bean = new UploadConfigBean();
            bean.setFile(multipartFile);
            ResultData resultData = this.prepareUpload(bean, true);
            if (resultData.isSuccess()) continue;
            return new EditorStateBean(false, resultData.getMsg()).toString();
        }
        return joinPoint.proceed();
    }

    private List<MultipartFile> getFiles(ProceedingJoinPoint pjp) throws Exception {
        String action = BasicUtil.getString((String)"action");
        ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
        MultipartFile file = null;
        switch (action) {
            case "uploadscrawl": {
                String base64 = SpringUtil.getRequest().getParameter("upfile");
                byte[] bytes = Base64.decodeBase64((String)base64);
                file = FileUtil.bytesToMultipartFile((byte[])bytes, (String)"png");
                if (!ObjectUtil.isNull((Object)file)) break;
                files.add(file);
                break;
            }
            case "uploadimage": 
            case "uploadvideo": 
            case "uploadfile": {
                Object[] args = pjp.getArgs();
                file = null;
                for (Object arg : args) {
                    if (!(arg instanceof MultipartFile)) continue;
                    file = (MultipartFile)arg;
                }
                files.add(file);
                break;
            }
            case "catchimage": {
                String[] remotes;
                for (String remote : remotes = SpringUtil.getRequest().getParameterValues("source[]")) {
                    if (StringUtils.isBlank((CharSequence)remote) || (file = FileUtil.remoteUrlToMultipartFile((String)remote, (String)"png")) == null) continue;
                    files.add(file);
                }
                break;
            }
        }
        return files;
    }
}

