/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action.web;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.biz.IHistoryLogBiz;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.cms.entity.HistoryLogEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u524d\u7aef-\u5185\u5bb9\u6a21\u5757\u63a5\u53e3")
@Controller(value="WebcmsContentAction")
@RequestMapping(value={"/cms/content"})
public class ContentAction
extends BaseAction {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IHistoryLogBiz historyLogBiz;

    @Operation(summary="\u67e5\u8be2\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="typeid", description="\u6240\u5c5e\u680f\u76ee", required=false, in=ParameterIn.QUERY), @Parameter(name="pageNo", description="\u9875\u7801", required=false, in=ParameterIn.QUERY), @Parameter(name="size", description="\u4e00\u9875\u663e\u793a\u6570\u91cf", required=false, in=ParameterIn.QUERY), @Parameter(name="orderby", description="\u6392\u5e8f", required=false, in=ParameterIn.QUERY)})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(HttpServletResponse response, HttpServletRequest request) {
        Map map = BasicUtil.assemblyRequestMap();
        String typeid = (String)map.get("typeid");
        if (StrUtil.isBlank((CharSequence)typeid)) {
            typeid = (String)map.get("categoryId");
        }
        ContentBean content = new ContentBean();
        if (StrUtil.isNotBlank((CharSequence)typeid)) {
            content.setCategoryId(typeid);
        }
        content.setCategoryType(CategoryTypeEnum.LIST.toString());
        content.setContentDisplay("0");
        List<CategoryBean> articleList = this.contentBiz.queryIdsByCategoryIdForParser(content);
        PageBean page = new PageBean();
        ArrayList filedStr = new ArrayList();
        page.setPageNo(BasicUtil.getInt((String)"pageNo", (int)1).intValue());
        page.setSize(BasicUtil.getInt((String)"size", (int)10).intValue());
        map.put("ispaging", "true");
        map.putIfAbsent("size", page.getSize());
        if (BasicUtil.getWebsiteApp() != null) {
            map.put("appid", BasicUtil.getWebsiteApp().getId());
        }
        map.put("pageTag", page);
        if (typeid != null) {
            ModelEntity contentModel;
            CategoryEntity column = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)typeid)));
            if (column != null && ObjectUtil.isNotNull((Object)column.getMdiyModelId()) && (contentModel = this.modelBiz.getById((Serializable)((Object)column.getMdiyModelId()))) != null) {
                Map fieldMap = contentModel.getFieldMap();
                for (String s : fieldMap.keySet()) {
                    filedStr.add(fieldMap.get(s));
                }
                map.put("tableName", contentModel.getModelTableName());
            }
            map.put("column", column);
        }
        List contentList = this.contentBiz.list(map);
        return ResultData.build().success((Object)new EUListBean(contentList, articleList.size()));
    }

    @Operation(summary="\u83b7\u53d6\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) ContentEntity content) {
        if (content.getId() == null) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("id")));
        }
        content.setSqlWhere("");
        ContentEntity _content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)content.getId())));
        if (_content == null) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("id")));
        }
        CategoryEntity categoryEntity = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)_content.getCategoryId())));
        ModelEntity modelEntity = new ModelEntity();
        if (categoryEntity != null) {
            modelEntity = this.modelBiz.getById((Serializable)((Object)categoryEntity.getMdiyModelId()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataid", content.getId());
        if (modelEntity != null && StringUtils.isNotBlank((CharSequence)modelEntity.getModelTableName())) {
            map.put("tableName", modelEntity.getModelTableName());
        }
        Map contentMap = this.contentBiz.get(map);
        return ResultData.build().success((Object)contentMap);
    }

    @Operation(summary="\u67e5\u770b\u6587\u7ae0\u70b9\u51fb\u6570")
    @Parameter(name="contentId", description="\u6587\u7ae0\u7f16\u53f7", required=true, in=ParameterIn.PATH)
    @GetMapping(value={"/{contentId}/hit"}, produces={"application/javascript"})
    @ResponseBody
    public String hit(@PathVariable @Parameter(hidden=true) String contentId) {
        if (StringUtils.isEmpty((CharSequence)contentId)) {
            return "document.write(0)";
        }
        String ip = BasicUtil.getIp();
        boolean isMobileDevice = BasicUtil.isMobileDevice();
        ContentEntity content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)contentId)));
        if (content == null) {
            return "document.write(0)";
        }
        if (ObjectUtil.isNotEmpty((Object)content.getContentHit())) {
            content.setContentHit(content.getContentHit() + 1);
        } else {
            content.setContentHit(1);
        }
        this.contentBiz.updateById((Object)content);
        HistoryLogEntity entity = new HistoryLogEntity();
        entity.setHlIsMobile(isMobileDevice);
        entity.setHlIp(ip);
        entity.setContentId(content.getId());
        entity.setCreateDate(new Date());
        this.historyLogBiz.save((Object)entity);
        return "document.write(" + content.getContentHit() + ")";
    }
}

