/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.aop;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.biz.IHistoryLogBiz;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.constant.e.ContentEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.cms.entity.HistoryLogEntity;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ContentAop
extends BaseAop {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IHistoryLogBiz historyLogBiz;
    @Value(value="${ms.diy.html-dir:html}")
    private String htmlDir;

    @Around(value="execution(* net.mingsoft.cms.action.web.ContentAction.get(..))")
    public Object get(ProceedingJoinPoint pjp) throws Throwable {
        ContentEntity content = (ContentEntity)((Object)this.getType((JoinPoint)pjp, ContentEntity.class));
        if (content.getId() == null) {
            return pjp.proceed();
        }
        if ((content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)content.getId())))) == null) {
            return pjp.proceed();
        }
        HistoryLogEntity historyLog = new HistoryLogEntity();
        historyLog.setContentId(content.getId());
        historyLog.setHlIp(BasicUtil.getIp());
        historyLog.setHlIsMobile(BasicUtil.isMobileDevice());
        historyLog.setCreateDate(new Date());
        this.historyLogBiz.save((Object)historyLog);
        if (content.getContentHit() == null) {
            content.setContentHit(1);
        } else {
            content.setContentHit(content.getContentHit() + 1);
        }
        this.contentBiz.updateById((Object)content);
        return pjp.proceed();
    }

    @Pointcut(value="execution(* net.mingsoft.cms.action.ContentAction.delete(..))")
    public void delete() {
    }

    @AfterReturning(value="delete()")
    public void delete(JoinPoint jp) {
        List contents = (List)this.getJsonParam(jp);
        String appDir = BasicUtil.getApp().getAppDir();
        Map categoryIdByContentIds = contents.stream().collect(Collectors.groupingBy(ContentEntity::getCategoryId, Collectors.mapping(ContentEntity::getId, Collectors.toList())));
        ArrayList<String> categoryIds = new ArrayList<String>(categoryIdByContentIds.keySet());
        for (String categoryId : categoryIds) {
            CategoryEntity category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)categoryId)));
            String contentPath = appDir + File.separator + category.getCategoryPath();
            for (String contentId : categoryIdByContentIds.get(categoryId)) {
                contentPath = contentPath + File.separator + contentId;
                this.deleteHtml(contentPath);
            }
        }
    }

    @Pointcut(value="execution(* net.mingsoft.cms.action.ContentAction.update(..))")
    public void update() {
    }

    @AfterReturning(value="update()")
    public void update(JoinPoint jp) {
        CategoryEntity category;
        ContentEntity contentEntity = (ContentEntity)((Object)this.getType(jp, ContentEntity.class));
        String appDir = BasicUtil.getApp().getAppDir();
        if (contentEntity != null && contentEntity.getContentDisplay().equals(ContentEnum.HIDE.toString()) && (category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)contentEntity.getCategoryId())))) != null) {
            String contentPath = appDir + File.separator + category.getCategoryPath();
            if (category.getCategoryType().equals(CategoryTypeEnum.COVER.toString())) {
                contentPath = contentPath + File.separator + "index";
                this.deleteHtml(contentPath);
            } else {
                contentPath = contentPath + File.separator + contentEntity.getId();
                this.deleteHtml(contentPath);
            }
        }
    }

    private void deleteHtml(String contentPath) {
        String htmlPath = BasicUtil.getRealPath((String)this.htmlDir);
        String path = htmlPath + File.separator + contentPath + ".html";
        if (path.contains("..") || path.contains("../") || path.contains("..\\")) {
            this.LOG.error("\u975e\u6cd5\u8def\u5f84\uff1a" + path);
            throw new BusinessException(BundleUtil.getString((String)"net.mingsoft.base.resources.resources", (String)"err.error", (String[])new String[]{BundleUtil.getString((String)"net.mingsoft.basic.resources.resources", (String)"file.path", (String[])new String[0])}));
        }
        boolean flag = FileUtil.del((String)path);
        if (flag) {
            this.LOG.info("\u5220\u9664\u9759\u6001\u6587\u4ef6\u6210\u529f\uff01");
        } else {
            this.LOG.error("\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

