/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.PinYinUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u5185\u5bb9\u6a21\u5757\u63a5\u53e3")
@Controller(value="cmsCategoryAction")
@RequestMapping(value={"/${ms.manager.path}/cms/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @Hidden
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"cms:category:view"})
    public String index() {
        return "/cms/category/index";
    }

    @Operation(summary="\u67e5\u8be2\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="categoryTitle", description="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryParentId", description="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (StrUtil.isBlank((CharSequence)category.getIsChild())) {
            category.setIsChild("cms");
        }
        List categoryList = this.categoryBiz.list((Wrapper)new LambdaQueryWrapper((Object)category));
        return ResultData.build().success((Object)new EUListBean(categoryList, categoryList.size()));
    }

    @Hidden
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute CategoryEntity category, ModelMap model) {
        model.addAttribute("appId", (Object)BasicUtil.getApp().getAppId());
        return "/cms/category/form";
    }

    @Operation(summary="\u83b7\u53d6\u5206\u7c7b\u8be6\u60c5\u63a5\u53e3")
    @Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"cms:category:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (StringUtils.isBlank((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("id")));
        }
        CategoryEntity _category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)category.getId())));
        return ResultData.build().success((Object)_category);
    }

    @Operation(summary="\u4fdd\u5b58\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="categoryTitle", description="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryType", description="\u680f\u76ee\u7c7b\u578b,1:\u5217\u8868,2:\u5355\u7bc7,3:\u94fe\u63a5", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryDisplay", description="\u680f\u76ee\u662f\u5426\u663e\u793a,enable:\u663e\u793a disable:\u4e0d\u663e\u793a", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryIsSearch", description="\u680f\u76ee\u662f\u5426\u53ef\u641c\u7d22,enable:\u53ef\u641c\u7d22 disable:\u4e0d\u53ef\u641c\u7d22", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryId", description="\u6240\u5c5e\u680f\u76ee", required=false, in=ParameterIn.QUERY), @Parameter(name="categorySort", description="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryListUrl", description="\u5217\u8868\u6a21\u677f", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryUrl", description="\u5185\u5bb9\u6a21\u677f", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryKeyword", description="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryDescrip", description="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryImg", description="\u7f29\u7565\u56fe", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryIco", description="\u680f\u76ee\u5c0f\u56fe", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryDiyUrl", description="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, in=ParameterIn.QUERY), @Parameter(name="mdiyModelId", description="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, in=ParameterIn.QUERY), @Parameter(name="dictId", description="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryFlag", description="\u680f\u76ee\u5c5e\u6027", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryPath", description="\u680f\u76ee\u8def\u5f84", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryParentIds", description="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @PostMapping(value={"/save"})
    @ResponseBody
    @LogAnn(title="\u4fdd\u5b58\u5206\u7c7b", businessType=BusinessTypeEnum.INSERT)
    @RequiresPermissions(value={"cms:category:save"})
    public ResultData save(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (category.getCategoryImg() == null || !category.getCategoryImg().matches("^\\[.{1,}]$")) {
            category.setCategoryImg("");
        }
        if (category.getCategoryIco() == null || !category.getCategoryIco().matches("^\\[.{1,}]$")) {
            category.setCategoryIco("");
        }
        if (StringUtils.isBlank((CharSequence)category.getCategoryTitle())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.title")));
        }
        if (!StringUtil.checkLength((String)category.getCategoryTitle(), (int)1, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.title"), "1", "200"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryDescrip(), (int)0, (int)500)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.descrip"), "0", "500"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryKeyword(), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.keyword"), "0", "100"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryPath(), (int)0, (int)400)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.path"), "0", "400"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryListUrl(), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.list.url"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryUrl(), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.url"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryDiyUrl(), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.diy.url"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryFlag(), (int)0, (int)20)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.flag"), "0", "20"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryType(), (int)0, (int)1)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.type"), "0", "1"));
        }
        if (!StringUtil.checkLength((String)category.getMdiyModelId(), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("mdiy.model.id"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryPinyin(), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.pinyin"), "1", "100"));
        }
        if (FileNameUtil.containsInvalid((String)category.getCategoryPinyin())) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("category.pinyin")));
        }
        if (!StringUtil.checkLength((String)category.getCategoryParentIds(), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.parent.id"), "1", "100"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryShortTitle(), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.short.title"), "0", "200"));
        }
        if (StringUtils.isBlank((CharSequence)category.getCategoryDisplay())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.display")));
        }
        if (StringUtils.isBlank((CharSequence)category.getCategoryIsSearch())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.is.search")));
        }
        if (StrUtil.isNotBlank((CharSequence)category.getCategoryPinyin())) {
            if (!category.getCategoryPinyin().matches("^[a-zA-Z0-9]*$")) {
                return ResultData.build().error(this.getResString("err.error", this.getResString("category.pinyin")));
            }
            CategoryEntity _category = new CategoryEntity();
            _category.setCategoryPinyin(category.getCategoryPinyin());
            List query = this.categoryBiz.query(_category);
            if (query.size() > 0) {
                return ResultData.build().error(this.getResString("err.exist", this.getResString("category.pinyin")));
            }
        }
        this.categoryBiz.saveEntity(category);
        return ResultData.build().success((Object)category);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="categorys", description="\u5220\u9664\u7684\u680f\u76ee\u96c6\u5408", schema=@Schema(allOf={CategoryEntity.class}), required=true)})
    @PostMapping(value={"/delete"})
    @ResponseBody
    @LogAnn(title="\u5220\u9664\u5206\u7c7b", businessType=BusinessTypeEnum.DELETE)
    @RequiresPermissions(value={"cms:category:del"})
    public ResultData delete(@RequestBody List<CategoryEntity> categorys) {
        for (int i = 0; i < categorys.size(); ++i) {
            this.categoryBiz.delete(categorys.get(i).getId());
        }
        return ResultData.build().success();
    }

    @Operation(summary="\u66f4\u65b0\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryTitle", description="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryDisplay", description="\u680f\u76ee\u662f\u5426\u663e\u793a,enable:\u663e\u793a disable:\u4e0d\u663e\u793a", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryIsSearch", description="\u680f\u76ee\u662f\u5426\u53ef\u641c\u7d22,enable:\u53ef\u641c\u7d22 disable:\u4e0d\u53ef\u641c\u7d22", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryType", description="\u680f\u76ee\u7c7b\u578b,1:\u5217\u8868,2:\u5355\u7bc7,3:\u94fe\u63a5", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryId", description="\u6240\u5c5e\u680f\u76ee", required=false, in=ParameterIn.QUERY), @Parameter(name="categorySort", description="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryListUrl", description="\u5217\u8868\u6a21\u677f", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryUrl", description="\u5185\u5bb9\u6a21\u677f", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryKeyword", description="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryDescrip", description="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryImg", description="banner\u56fe", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryIco", description="\u680f\u76ee\u5c0f\u56fe", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryDiyUrl", description="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, in=ParameterIn.QUERY), @Parameter(name="mdiyModelId", description="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, in=ParameterIn.QUERY), @Parameter(name="dictId", description="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryFlag", description="\u680f\u76ee\u5c5e\u6027", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryPath", description="\u680f\u76ee\u8def\u5f84", required=false, in=ParameterIn.QUERY), @Parameter(name="categoryParentIds", description="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @PostMapping(value={"/update"})
    @ResponseBody
    @LogAnn(title="\u66f4\u65b0\u5206\u7c7b", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"cms:category:update"})
    public ResultData update(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (category.getCategoryImg() == null || !category.getCategoryImg().matches("^\\[.{1,}]$")) {
            category.setCategoryImg("");
        }
        if (category.getCategoryIco() == null || !category.getCategoryIco().matches("^\\[.{1,}]$")) {
            category.setCategoryIco("");
        }
        if (StringUtils.isEmpty((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.id")));
        }
        if (StringUtils.isBlank((CharSequence)category.getCategoryTitle())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.title")));
        }
        if (!StringUtil.checkLength((String)category.getCategoryTitle(), (int)1, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.title"), "1", "200"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryDescrip(), (int)0, (int)500)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.descrip"), "0", "500"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryKeyword(), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.keyword"), "0", "100"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryDiyUrl(), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.diy.url"), "0", "200"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryFlag(), (int)0, (int)20)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.flag"), "0", "20"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryListUrl(), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.list.url"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryPath(), (int)0, (int)400)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.path"), "0", "400"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryType(), (int)0, (int)1)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.type"), "0", "1"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryUrl(), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.url"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)category.getMdiyModelId(), (int)0, (int)50)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("mdiy.model.id"), "0", "50"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryParentIds(), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.parent.id"), "1", "100"));
        }
        if (!StringUtil.checkLength((String)category.getCategoryShortTitle(), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.short.title"), "0", "200"));
        }
        if (StringUtils.isBlank((CharSequence)category.getCategoryDisplay())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.display")));
        }
        if (StringUtils.isBlank((CharSequence)category.getCategoryIsSearch())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.is.search")));
        }
        if (FileNameUtil.containsInvalid((String)category.getCategoryPinyin())) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("category.pinyin")));
        }
        if (StrUtil.isNotBlank((CharSequence)category.getCategoryPinyin()) && !((CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)category.getId())))).getCategoryPinyin().equals(category.getCategoryPinyin())) {
            if (!category.getCategoryPinyin().matches("^[a-zA-Z0-9]*$")) {
                return ResultData.build().error(this.getResString("err.error", this.getResString("category.pinyin")));
            }
            CategoryEntity _category = new CategoryEntity();
            _category.setCategoryPinyin(category.getCategoryPinyin());
            List query = this.categoryBiz.query(_category);
            if (query.size() > 0) {
                return ResultData.build().error(this.getResString("err.exist", this.getResString("category.pinyin")));
            }
        }
        String pingYin = PinYinUtil.getPingYin((String)category.getCategoryTitle());
        if (StrUtil.isNotBlank((CharSequence)category.getCategoryPinyin()) && StringUtil.checkLength((String)category.getCategoryPinyin(), (int)1, (int)100)) {
            pingYin = category.getCategoryPinyin();
        }
        CategoryEntity categoryEntity = new CategoryEntity();
        categoryEntity.setCategoryPinyin(pingYin);
        CategoryEntity categoryBizEntity = (CategoryEntity)((Object)this.categoryBiz.getOne((Wrapper)new LambdaQueryWrapper((Object)categoryEntity)));
        category.setCategoryPinyin(pingYin);
        if (categoryBizEntity != null && !categoryBizEntity.getId().equals(category.getId())) {
            category.setCategoryPinyin(pingYin + category.getId());
        }
        CategoryEntity _category = new CategoryEntity();
        _category.setId(category.getId());
        List<CategoryEntity> categoryList = this.categoryBiz.queryChildren(_category);
        if (categoryList.size() > 1) {
            for (CategoryEntity item : categoryList) {
                if (!item.getId().equals(category.getCategoryId())) continue;
                return ResultData.build().error(this.getResString("cannot.select.child"));
            }
            category.setLeaf(false);
        } else {
            category.setLeaf(true);
        }
        this.categoryBiz.updateEntity(category);
        return ResultData.build().success((Object)category);
    }

    @Operation(summary="\u9a8c\u8bc1\u62fc\u97f3")
    @Parameters(value={@Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryPinyin", description="\u680f\u76ee\u7ba1\u62fc\u97f3", required=true, in=ParameterIn.QUERY)})
    @GetMapping(value={"/verifyPingYin"})
    @ResponseBody
    public ResultData verifyPingYin(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (StringUtils.isEmpty((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("id")));
        }
        if (!StringUtil.checkLength((String)category.getId(), (int)0, (int)20)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("id"), "0", "20"));
        }
        if (StringUtils.isEmpty((CharSequence)category.getCategoryPinyin())) {
            return ResultData.build().error(this.getResString("err.empty", this.getResString("category.pinyin")));
        }
        if (FileNameUtil.containsInvalid((String)category.getCategoryPinyin())) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("category.pinyin")));
        }
        if (!StringUtil.checkLength((String)category.getCategoryPinyin(), (int)0, (int)255)) {
            return ResultData.build().error(this.getResString("err.length", this.getResString("category.pinyin"), "0", "255"));
        }
        long count = this.categoryBiz.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(StrUtil.isNotBlank((CharSequence)category.getId()), CategoryEntity::getId, (Object)category.getId())).eq(CategoryEntity::getCategoryPinyin, (Object)category.getCategoryPinyin()));
        if (count > 0L) {
            return ResultData.build().error("\u5b58\u5728\u76f8\u540c\u62fc\u97f3\u7684\u680f\u76ee");
        }
        return ResultData.build().success();
    }

    @Operation(summary="\u6279\u91cf\u66f4\u65b0\u6a21\u677f")
    @Parameters(value={@Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY)})
    @GetMapping(value={"/updateTemplate"})
    @ResponseBody
    @RequiresPermissions(value={"cms:category:update"})
    public ResultData updateTemplate(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (category == null || StringUtils.isEmpty((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("id")));
        }
        category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)category.getId())));
        category.setCategoryParentIds(null);
        List<CategoryEntity> childs = this.categoryBiz.queryChildren(category);
        for (int i = 0; i < childs.size(); ++i) {
            if (!childs.get(i).getCategoryType().equals(category.getCategoryType())) continue;
            childs.get(i).setCategoryUrl(category.getCategoryUrl());
            childs.get(i).setCategoryListUrl(category.getCategoryListUrl());
            this.categoryBiz.updateEntity(childs.get(i));
        }
        return ResultData.build().success();
    }

    @Operation(summary="\u590d\u5236\u680f\u76ee")
    @Parameters(value={@Parameter(name="id", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY)})
    @GetMapping(value={"/copyCategory"})
    @ResponseBody
    @RequiresPermissions(value={"cms:category:save"})
    public ResultData copyCategory(@ModelAttribute @Parameter(hidden=true) CategoryEntity category) {
        if (category == null || StringUtils.isEmpty((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("id")));
        }
        this.categoryBiz.copyCategory(category);
        return ResultData.build().success();
    }

    @Operation(summary="\u5f3a\u5236\u8f6c\u6362\u7c7b\u578b\u63a5\u53e3")
    @Parameters(value={@Parameter(name="typeid", description="\u7f16\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="categoryType", description="\u680f\u76ee\u7c7b\u578b,1:\u5217\u8868,2:\u5355\u7bc7,3:\u94fe\u63a5", required=true, in=ParameterIn.QUERY)})
    @GetMapping(value={"/changeType"})
    @ResponseBody
    @RequiresPermissions(value={"cms:category:update"})
    public ResultData changeType() {
        String typeId = BasicUtil.getString((String)"typeid");
        String categoryType = BasicUtil.getString((String)"categoryType");
        CategoryEntity category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)typeId)));
        if (category == null) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("id")));
        }
        if (CategoryTypeEnum.get(categoryType).equals((Object)CategoryTypeEnum.UN_KNOW)) {
            return ResultData.build().error(this.getResString("err.error", this.getResString("category.type")));
        }
        this.categoryBiz.changeCategoryType(category, categoryType);
        return ResultData.build().success((Object)category);
    }
}

