/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.biz.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.dao.ICategoryDao;
import net.mingsoft.cms.dao.IContentDao;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.mdiy.biz.ITagBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.entity.TagEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cmscontentBizImpl")
public class ContentBizImpl
extends BaseBizImpl<IContentDao, ContentEntity>
implements IContentBiz {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContentDao contentDao;
    @Autowired
    private ICategoryDao categoryDao;
    @Autowired
    private ITagBiz tagBiz;

    protected IBaseDao getDao() {
        return this.contentDao;
    }

    @Override
    public List<CategoryBean> queryIdsByCategoryIdForParser(ContentBean contentBean) {
        return this.contentDao.queryIdsByCategoryIdForParser(contentBean);
    }

    @Override
    public List<ContentBean> queryContent(ContentBean contentBean) {
        return this.contentDao.queryContent(contentBean);
    }

    @Override
    public int getSearchCount(ModelEntity contentModel, List diyList, Map whereMap, String categoryIds) {
        if (contentModel != null) {
            return this.contentDao.getSearchCount(contentModel.getModelTableName(), diyList, whereMap, categoryIds);
        }
        return this.contentDao.getSearchCount(null, null, whereMap, categoryIds);
    }

    @Override
    public List<CategoryBean> queryIdsByCategoryIdForParserAndNotCover(ContentBean contentBean) {
        return this.contentDao.queryIdsByCategoryIdForParserAndNotCover(contentBean);
    }

    @Override
    public List list(Map map) {
        QueryWrapper tagWrapper = new QueryWrapper();
        tagWrapper.eq((Object)"tag_name", (Object)"arclist");
        TagEntity tagEntity = (TagEntity)this.tagBiz.getOne((Wrapper)tagWrapper);
        String sqlFtl = tagEntity.getTagSql();
        List contentEntities = null;
        try {
            String sql = ParserUtil.rendering((Map)map, (String)sqlFtl);
            contentEntities = (List)this.tagBiz.excuteSql(sql);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return contentEntities;
    }

    @Override
    public Map get(Map map) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TagEntity::getTagName, (Object)"data");
        TagEntity tagEntity = (TagEntity)this.tagBiz.getOne((Wrapper)wrapper);
        if (tagEntity == null) {
            return null;
        }
        String sqlFtl = tagEntity.getTagSql();
        Map content = null;
        try {
            String sql = ParserUtil.rendering((Map)map, (String)sqlFtl);
            List contentEntities = (List)this.tagBiz.excuteSql(sql);
            if (CollUtil.isEmpty((Collection)contentEntities)) {
                return null;
            }
            content = (Map)contentEntities.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }
}

