/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action.web;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.biz.IHistoryLogBiz;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.cms.entity.HistoryLogEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u524d\u7aef-\u5185\u5bb9\u6a21\u5757\u63a5\u53e3"})
@Controller(value="WebcmsContentAction")
@RequestMapping(value={"/cms/content"})
public class ContentAction
extends BaseAction {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IHistoryLogBiz historyLogBiz;

    @ApiOperation(value="\u67e5\u8be2\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeid", value="\u6240\u5c5e\u680f\u76ee", required=true, paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u4e00\u9875\u663e\u793a\u6570\u91cf", required=false, paramType="query"), @ApiImplicitParam(name="orderby", value="\u6392\u5e8f", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(HttpServletResponse response, HttpServletRequest request) {
        Map map = BasicUtil.assemblyRequestMap();
        String typeid = (String)map.get("typeid");
        if (StrUtil.isBlank((CharSequence)typeid)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("content.category.id")}));
        }
        ContentBean content = new ContentBean();
        content.setCategoryType(CategoryTypeEnum.LIST.toString());
        content.setContentDisplay("0");
        content.setCategoryId(typeid);
        List<CategoryBean> articleList = this.contentBiz.queryIdsByCategoryIdForParser(content);
        PageBean page = new PageBean();
        ArrayList filedStr = new ArrayList();
        page.setPageNo(BasicUtil.getInt((String)"pageNo", (int)1).intValue());
        page.setSize(BasicUtil.getInt((String)"size", (int)10).intValue());
        map.put("ispaging", "true");
        map.putIfAbsent("size", page.getSize());
        if (BasicUtil.getWebsiteApp() != null) {
            map.put("appid", BasicUtil.getWebsiteApp().getId());
        }
        map.put("pageTag", page);
        if (typeid != null) {
            ModelEntity contentModel;
            CategoryEntity column = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)typeid)));
            if (column != null && ObjectUtil.isNotNull((Object)column.getMdiyModelId()) && (contentModel = this.modelBiz.getById((Serializable)((Object)column.getMdiyModelId()))) != null) {
                Map fieldMap = contentModel.getFieldMap();
                for (String s : fieldMap.keySet()) {
                    filedStr.add(fieldMap.get(s));
                }
                map.put("tableName", contentModel.getModelTableName());
            }
            map.put("column", column);
        }
        List contentList = this.contentBiz.list(map);
        return ResultData.build().success((Object)new EUListBean(contentList, articleList.size()));
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore ContentEntity content) {
        if (content.getId() == null) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        content.setSqlWhere("");
        ContentEntity _content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)content.getId())));
        if (_content == null) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        CategoryEntity categoryEntity = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)_content.getCategoryId())));
        ModelEntity modelEntity = new ModelEntity();
        if (categoryEntity != null) {
            modelEntity = this.modelBiz.getById((Serializable)((Object)categoryEntity.getMdiyModelId()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dataid", content.getId());
        if (modelEntity != null && StringUtils.isNotBlank((CharSequence)modelEntity.getModelTableName())) {
            map.put("tableName", modelEntity.getModelTableName());
        }
        Map contentMap = this.contentBiz.get(map);
        return ResultData.build().success((Object)contentMap);
    }

    @ApiOperation(value="\u67e5\u770b\u6587\u7ae0\u70b9\u51fb\u6570")
    @ApiImplicitParam(name="contentId", value="\u6587\u7ae0\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{contentId}/hit"}, produces={"application/javascript"})
    @ResponseBody
    public String hit(@PathVariable @ApiIgnore String contentId) {
        if (StringUtils.isEmpty((CharSequence)contentId)) {
            return "document.write(0)";
        }
        String ip = BasicUtil.getIp();
        boolean isMobileDevice = BasicUtil.isMobileDevice();
        ContentEntity content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)contentId)));
        if (content == null) {
            return "document.write(0)";
        }
        if (ObjectUtil.isNotEmpty((Object)content.getContentHit())) {
            content.setContentHit(content.getContentHit() + 1);
        } else {
            content.setContentHit(1);
        }
        this.contentBiz.updateById((Object)content);
        HistoryLogEntity entity = new HistoryLogEntity();
        entity.setHlIsMobile(isMobileDevice);
        entity.setHlIp(ip);
        entity.setContentId(content.getId());
        entity.setCreateDate(new Date());
        this.historyLogBiz.save((Object)entity);
        return "document.write(" + content.getContentHit() + ")";
    }
}

