/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.holder.DataHolder;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.dao.ICategoryDao;
import net.mingsoft.cms.dao.IContentDao;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.cms.util.CmsParserUtil;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="cmscontentBizImpl")
public class ContentBizImpl
extends BaseBizImpl<IContentDao, ContentEntity>
implements IContentBiz {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContentDao contentDao;
    @Autowired
    private ICategoryDao categoryDao;
    @Value(value="${ms.diy.html-dir:html}")
    private String htmlDir;

    protected IBaseDao getDao() {
        return this.contentDao;
    }

    @Override
    public List<CategoryBean> queryIdsByCategoryIdForParser(ContentBean contentBean) {
        return this.contentDao.queryIdsByCategoryIdForParser(contentBean);
    }

    @Override
    public int getSearchCount(ModelEntity contentModel, List diyList, Map whereMap, int appId, String categoryIds) {
        if (contentModel != null) {
            return this.contentDao.getSearchCount(contentModel.getModelTableName(), diyList, whereMap, appId, categoryIds);
        }
        return this.contentDao.getSearchCount(null, null, whereMap, appId, categoryIds);
    }

    public void staticizeTask(Integer appId, String tmpFileName, String generateFileName) {
        this.LOG.info("\u5b9a\u65f6\u9759\u6001\u5316\u4efb\u52a1", (Object)new Date());
        try {
            DataHolder.set((String)"appId", (Object)appId);
            this.genernateColumn();
            this.generaterIndex(tmpFileName, generateFileName);
            this.generateArticle(DateUtil.format((Date)DateUtil.yesterday(), (String)"yyyy-MM-dd"));
            this.LOG.info("\u9759\u6001\u5316\u5b8c\u6210", (Object)new Date());
        }
        catch (IOException e) {
            this.LOG.info("\u9759\u6001\u5316\u5931\u8d25", (Object)new Date());
            e.printStackTrace();
        }
    }

    private void generateArticle(String dateTime) throws IOException {
        List<CategoryBean> articleIdList = null;
        List categoryList = null;
        ContentBean contentBean = new ContentBean();
        contentBean.setBeginTime(dateTime);
        HashMap<String, String> map = new HashMap<String, String>();
        if (BasicUtil.getWebsiteApp() != null) {
            map.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
        }
        PageBean page = new PageBean();
        map.put("html", this.htmlDir);
        map.put("url", BasicUtil.getUrl());
        map.put("pageTag", (String)page);
        CategoryEntity categoryEntity = new CategoryEntity();
        categoryList = this.categoryDao.query(categoryEntity);
        for (CategoryEntity category : categoryList) {
            contentBean.setCategoryId(category.getId());
            if (category.getCategoryType().equals(CategoryTypeEnum.LIST.toString()) && (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)category.getCategoryListUrl())) || StringUtils.isEmpty((CharSequence)category.getCategoryListUrl()))) {
                this.LOG.error("\u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)category.getCategoryUrl());
                continue;
            }
            articleIdList = this.queryIdsByCategoryIdForParser(contentBean);
            if (articleIdList.size() <= 0) continue;
            CmsParserUtil.generateBasic(articleIdList, this.htmlDir);
        }
    }

    private void genernateColumn() throws IOException {
        List columns = new ArrayList();
        CategoryEntity categoryEntity = new CategoryEntity();
        columns = this.categoryDao.query(categoryEntity);
        List<CategoryBean> articleIdList = null;
        for (CategoryEntity column : columns) {
            ContentBean contentBean = new ContentBean();
            contentBean.setCategoryId(column.getId());
            if (column.getCategoryType().equals(CategoryTypeEnum.LIST.toString())) {
                if (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)column.getCategoryListUrl()))) {
                    this.LOG.error("\u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)column.getCategoryUrl());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                if (BasicUtil.getWebsiteApp() != null) {
                    map.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
                }
                PageBean page = new PageBean();
                map.put("html", this.htmlDir);
                map.put("url", BasicUtil.getUrl());
                map.put("pageTag", (String)page);
            }
            articleIdList = this.contentDao.queryIdsByCategoryIdForParser(contentBean);
            switch (CategoryTypeEnum.get(column.getCategoryType())) {
                case LIST: {
                    CmsParserUtil.generateList(column, articleIdList.size(), this.htmlDir);
                    break;
                }
                case COVER: {
                    if (articleIdList.size() == 0) {
                        CategoryBean columnArticleIdBean = new CategoryBean();
                        CopyOptions copyOptions = CopyOptions.create();
                        copyOptions.setIgnoreError(true);
                        BeanUtil.copyProperties((Object)((Object)column), (Object)((Object)columnArticleIdBean), (CopyOptions)copyOptions);
                        articleIdList.add(columnArticleIdBean);
                    }
                    CmsParserUtil.generateBasic(articleIdList, this.htmlDir);
                }
            }
        }
    }

    private void generaterIndex(String templatePath, String targetPath) throws IOException {
        if (!FileUtil.exist((String)ParserUtil.buildTempletPath())) {
            this.LOG.info("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDo", false);
        CategoryEntity column = new CategoryEntity();
        map.put("column", (Object)column);
        if (ParserUtil.IS_SINGLE) {
            map.put("url", BasicUtil.getUrl());
        }
        map.put("html", this.htmlDir);
        if (BasicUtil.getWebsiteApp() != null) {
            map.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
        }
        String read = ParserUtil.rendering((String)templatePath, map);
        FileUtil.writeString((String)read, (String)ParserUtil.buildHtmlPath((String)targetPath, (String)this.htmlDir), (String)"utf-8");
    }
}

