/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.bean.RoleBean;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u89d2\u8272\u7ba1\u7406\u63a7\u5236\u5c42")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/role"})
public class RoleAction
extends BaseAction {
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/role/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="roleManagerId", value="\u8be5\u89d2\u8272\u7684\u521b\u5efa\u8005ID", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        role.setRoleManagerId(managerSession.getManagerId());
        role.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List roleList = this.roleBiz.query(role);
        return ResultData.build().success((Object)new EUListBean(roleList, (int)BasicUtil.endPage(roleList).getTotal()));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u6a21\u5757\u96c6\u5408")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, paramType="path")
    @GetMapping(value={"/{roleId}/queryByRole"})
    @ResponseBody
    public ResultData queryByRole(@PathVariable @ApiIgnore int roleId, HttpServletResponse response) {
        List<BaseEntity> models = this.modelBiz.queryModelByRoleId(roleId);
        return ResultData.build().success(models);
    }

    @ApiOperation(value="\u8fd4\u56de\u7f16\u8f91\u754c\u9762role_form")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, paramType="query")
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (role.getRoleId() > 0) {
            BaseEntity roleEntity = this.roleBiz.getEntity(role.getRoleId());
            model.addAttribute("roleEntity", (Object)roleEntity);
        }
        return "/basic/role/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (role.getRoleId() <= 0) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("role.id")}));
        }
        RoleEntity _role = (RoleEntity)this.roleBiz.getEntity(role.getRoleId());
        return ResultData.build().success((Object)_role);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="roleManagerId", value="\u8be5\u89d2\u8272\u7684\u521b\u5efa\u8005ID", required=false, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u89d2\u8272\u5b9e\u4f53", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/saveOrUpdateRole"})
    @ResponseBody
    @RequiresPermissions(value={"role:save"})
    public ResultData saveOrUpdateRole(@ModelAttribute @ApiIgnore RoleBean role, HttpServletResponse response, HttpServletRequest request) {
        RoleBean _role = new RoleBean();
        _role.setRoleName(role.getRoleName());
        _role.setAppId(BasicUtil.getAppId());
        role.setAppId(BasicUtil.getAppId());
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        role.setRoleManagerId(managerSession.getManagerId());
        if (StringUtils.isEmpty((Object)role.getRoleName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("rolrName")}));
        }
        RoleBean roleBean = (RoleBean)((Object)this.roleBiz.getEntity(_role));
        if (role.getRoleId() > 0) {
            if (roleBean != null && roleBean.getRoleId() != role.getRoleId()) {
                return ResultData.build().error(this.getResString("roleName.exist"));
            }
            this.roleBiz.updateEntity(role);
        } else {
            if (roleBean != null) {
                return ResultData.build().error(this.getResString("roleName.exist"));
            }
            this.roleBiz.saveEntity(role);
        }
        ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
        if (!StringUtils.isEmpty((Object)role.getIds())) {
            for (String id : role.getIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setRoleId(role.getRoleId());
                roleModel.setModelId(Integer.parseInt(id));
                roleModelList.add(roleModel);
            }
            this.roleModelBiz.deleteEntity(role.getRoleId());
            this.roleModelBiz.saveEntity(roleModelList);
        } else {
            this.roleModelBiz.deleteEntity(role.getRoleId());
        }
        return ResultData.build().success((Object)role);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"role:del"})
    @LogAnn(title="\u5220\u9664\u89d2\u8272", businessType=BusinessTypeEnum.DELETE)
    public ResultData delete(@RequestBody List<RoleEntity> roles, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[roles.size()];
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int currentRoleId = managerSession.getManagerRoleID();
        for (int i = 0; i < roles.size(); ++i) {
            if (currentRoleId == roles.get(i).getRoleId()) continue;
            ids[i] = roles.get(i).getRoleId();
        }
        this.roleBiz.delete(ids);
        return ResultData.build().success();
    }
}

