/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.sorting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.sorting.FeaturesAlphabeticalComparator;
import net.masterthought.cucumber.sorting.SoringMethod;
import net.masterthought.cucumber.sorting.StepObjectAlphabeticalComparator;
import net.masterthought.cucumber.sorting.TagObjectAlphabeticalComparator;

public final class SortingFactory {
    private final SoringMethod soringMethod;

    public SortingFactory(SoringMethod soringMethod) {
        this.soringMethod = soringMethod;
    }

    public List<Feature> sortFeatures(Collection<Feature> features) {
        switch (this.soringMethod) {
            case NATURAL: {
                return new ArrayList<Feature>(features);
            }
            case ALPHABETICAL: {
                return SortingFactory.toSortedList(features, new FeaturesAlphabeticalComparator());
            }
        }
        throw this.createUnknownMethodException(this.soringMethod);
    }

    public List<TagObject> sortTags(Collection<TagObject> tags) {
        switch (this.soringMethod) {
            case NATURAL: {
                return new ArrayList<TagObject>(tags);
            }
            case ALPHABETICAL: {
                return SortingFactory.toSortedList(tags, new TagObjectAlphabeticalComparator());
            }
        }
        throw this.createUnknownMethodException(this.soringMethod);
    }

    public List<StepObject> sortSteps(Collection<StepObject> steps) {
        switch (this.soringMethod) {
            case NATURAL: {
                return new ArrayList<StepObject>(steps);
            }
            case ALPHABETICAL: {
                return SortingFactory.toSortedList(steps, new StepObjectAlphabeticalComparator());
            }
        }
        throw this.createUnknownMethodException(this.soringMethod);
    }

    private static <T> List<T> toSortedList(Collection<T> values, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(values);
        Collections.sort(list, comparator);
        return list;
    }

    private RuntimeException createUnknownMethodException(SoringMethod soringMethod) {
        return new IllegalArgumentException("Unsupported sorting method: " + (Object)((Object)soringMethod));
    }
}

