/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import net.ltgt.gradle.apt.AptPlugin;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;

class AptPlugin43to44
extends AptPlugin.Impl {
    AptPlugin43to44() {
    }

    @Override
    protected <T extends Task> Object createTask(Project project, String taskName, Class<T> taskClass, Action<T> configure2) {
        return project.getTasks().create(taskName, taskClass, configure2);
    }

    @Override
    protected <T extends Task> void configureTasks(Project project, Class<T> taskClass, Action<T> configure2) {
        project.getTasks().withType(taskClass, configure2);
    }

    @Override
    protected <T extends Task> Object configureTask(Project project, Class<T> taskClass, String taskName, Action<T> configure2) {
        return project.getTasks().withType(taskClass).getByName(taskName, configure2);
    }

    @Override
    protected AptPlugin.AptOptions createAptOptions() {
        return new AptPlugin.AptOptions();
    }

    @Override
    protected void configureCompileTask(AbstractCompile task, CompileOptions compileOptions, AptPlugin.AptOptions aptOptions) {
        task.getInputs().property("aptOptions.annotationProcessing", aptOptions::isAnnotationProcessing);
        task.getInputs().property("aptOptions.processors", aptOptions::getProcessors).optional(true);
        task.getInputs().property("aptOptions.processorArgs", aptOptions::getProcessorArgs).optional(true);
        task.doFirst("configure options.compilerArgs from aptOptions", task1 -> compileOptions.getCompilerArgs().addAll(aptOptions.asArguments()));
    }

    @Override
    protected void ensureConfigurations(Project project, SourceSet sourceSet) {
        Configuration annotationProcessorConfiguration = (Configuration)project.getConfigurations().create(this.getAnnotationProcessorConfigurationName(sourceSet));
        annotationProcessorConfiguration.setVisible(false);
        annotationProcessorConfiguration.setDescription("Annotation processors and their dependencies for " + sourceSet.getName() + ".");
        AptPlugin.AptSourceSetConvention convention = new AptPlugin.AptSourceSetConvention(project, sourceSet, annotationProcessorConfiguration);
        ((HasConvention)sourceSet).getConvention().getPlugins().put("net.ltgt.apt", convention);
    }

    @Override
    protected void configureCompileTaskForSourceSet(Project project, SourceSet sourceSet, CompileOptions compileOptions) {
        compileOptions.setAnnotationProcessorPath((FileCollection)project.files(new Object[]{() -> ((AptPlugin.AptSourceSetConvention)((HasConvention)sourceSet).getConvention().getPlugin(AptPlugin.AptSourceSetConvention.class)).getAnnotationProcessorPath()}));
    }

    @Override
    String getAnnotationProcessorConfigurationName(SourceSet sourceSet) {
        return sourceSet.getTaskName("", "annotationProcessor");
    }
}

