/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.loomchild.segment.AbstractTextIterator;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.RuleManager;
import net.loomchild.segment.srx.RuleMatcher;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.TextManager;
import net.loomchild.segment.util.Util;

public class SrxTextIterator
extends AbstractTextIterator {
    public static final String MARGIN_PARAMETER = "margin";
    public static final String BUFFER_LENGTH_PARAMETER = "bufferLength";
    public static final String MAX_LOOKBEHIND_CONSTRUCT_LENGTH_PARAMETER = "maxLookbehindConstructLength";
    public static final String DEFAULT_PATTERN_FLAGS_PARAMETER = "defaultPatternFlags";
    public static final int DEFAULT_MARGIN = 128;
    public static final int DEFAULT_BUFFER_LENGTH = 0x100000;
    public static final int DEFAULT_MAX_LOOKBEHIND_CONSTRUCT_LENGTH = 100;
    private SrxDocument document;
    private String segment;
    private int start;
    private int end;
    private TextManager textManager;
    private RuleManager ruleManager;
    private List<RuleMatcher> ruleMatcherList;
    private int margin;

    public SrxTextIterator(SrxDocument document, String languageCode, CharSequence text, Map<String, Object> parameterMap) {
        HashMap<String, Object> newParameterMap = new HashMap<String, Object>(parameterMap);
        newParameterMap.put(MARGIN_PARAMETER, 0);
        this.init(document, languageCode, new TextManager(text), newParameterMap);
    }

    public SrxTextIterator(SrxDocument document, String languageCode, CharSequence text) {
        this(document, languageCode, text, Util.getEmptyParameterMap());
    }

    public SrxTextIterator(SrxDocument document, String languageCode, Reader reader, Map<String, Object> parameterMap) {
        int bufferLength = Util.getParameter(parameterMap.get(BUFFER_LENGTH_PARAMETER), 0x100000);
        this.init(document, languageCode, new TextManager(reader, bufferLength), parameterMap);
    }

    public SrxTextIterator(SrxDocument document, String languageCode, Reader reader) {
        this(document, languageCode, reader, new HashMap<String, Object>());
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            if (this.segment == null) {
                this.initMatchers();
            }
            boolean found = false;
            while (!found) {
                RuleMatcher minMatcher = this.getMinMatcher();
                if (minMatcher == null && !this.textManager.hasMoreText()) {
                    found = true;
                    this.end = this.textManager.getText().length();
                } else {
                    if (this.textManager.hasMoreText() && (minMatcher == null || minMatcher.getBreakPosition() > this.textManager.getBufferLength() - this.margin)) {
                        if (this.start == 0) {
                            throw new IllegalStateException("Buffer too short - it must be at least as long as the longest segment in the text; try using the bufferLength option");
                        }
                        this.textManager.readText(this.start);
                        this.start = 0;
                        this.initMatchers();
                        minMatcher = this.getMinMatcher();
                    }
                    this.end = minMatcher.getBreakPosition();
                    if (this.end > this.start && (found = this.isException(minMatcher))) {
                        this.cutMatchers();
                    }
                }
                this.moveMatchers();
            }
            this.segment = this.textManager.getText().subSequence(this.start, this.end).toString();
            this.start = this.end;
            return this.segment;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.textManager.hasMoreText() || this.start < this.textManager.getText().length();
    }

    private void init(SrxDocument document, String languageCode, TextManager textManager, Map<String, Object> parameterMap) {
        int margin = Util.getParameter(parameterMap.get(MARGIN_PARAMETER), 128);
        int maxLookbehindConstructLength = Util.getParameter(parameterMap.get(MAX_LOOKBEHIND_CONSTRUCT_LENGTH_PARAMETER), 100);
        int defaultPatternFlags = Util.getParameter(parameterMap.get(DEFAULT_PATTERN_FLAGS_PARAMETER), 0);
        Util.setDefaultPatternFlags(defaultPatternFlags);
        if (textManager.getBufferLength() > 0 && textManager.getBufferLength() <= margin) {
            throw new IllegalArgumentException("Margin: " + margin + " must be smaller than buffer itself: " + textManager.getBufferLength() + ".");
        }
        this.document = document;
        this.segment = null;
        this.start = 0;
        this.end = 0;
        this.textManager = textManager;
        this.margin = margin;
        List<LanguageRule> languageRuleList = document.getLanguageRuleList(languageCode);
        String key = "RULE_MANAGER_" + this.toString(languageRuleList) + "_" + maxLookbehindConstructLength;
        this.ruleManager = (RuleManager)document.getCache().get(key);
        if (this.ruleManager == null) {
            this.ruleManager = new RuleManager(document, languageRuleList, maxLookbehindConstructLength);
            document.getCache().put(key, this.ruleManager);
        }
    }

    private void initMatchers() {
        this.ruleMatcherList = new LinkedList<RuleMatcher>();
        for (Rule rule : this.ruleManager.getBreakRuleList()) {
            RuleMatcher matcher = new RuleMatcher(this.document, rule, this.textManager.getText());
            matcher.find();
            if (matcher.hitEnd()) continue;
            this.ruleMatcherList.add(matcher);
        }
    }

    private void moveMatchers() {
        Iterator<RuleMatcher> i = this.ruleMatcherList.iterator();
        block0: while (i.hasNext()) {
            RuleMatcher matcher = i.next();
            while (matcher.getBreakPosition() <= this.end) {
                matcher.find();
                if (!matcher.hitEnd()) continue;
                i.remove();
                continue block0;
            }
        }
    }

    private void cutMatchers() {
        Iterator<RuleMatcher> i = this.ruleMatcherList.iterator();
        while (i.hasNext()) {
            RuleMatcher matcher = i.next();
            if (matcher.getStartPosition() >= this.end) continue;
            matcher.find(this.end);
            if (!matcher.hitEnd()) continue;
            i.remove();
        }
    }

    private RuleMatcher getMinMatcher() {
        int minPosition = Integer.MAX_VALUE;
        RuleMatcher minMatcher = null;
        for (RuleMatcher matcher : this.ruleMatcherList) {
            if (matcher.getBreakPosition() >= minPosition) continue;
            minPosition = matcher.getBreakPosition();
            minMatcher = matcher;
        }
        return minMatcher;
    }

    private boolean isException(RuleMatcher ruleMatcher) {
        Pattern pattern = this.ruleManager.getExceptionPattern(ruleMatcher.getRule());
        if (pattern != null) {
            Matcher matcher = pattern.matcher(this.textManager.getText());
            matcher.useTransparentBounds(true);
            matcher.region(ruleMatcher.getBreakPosition(), this.textManager.getText().length());
            return !matcher.lookingAt();
        }
        return true;
    }
}

