/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.content;

import java.util.Arrays;
import java.util.Random;
import net.logicsquad.nanocaptcha.content.ContentProducer;

public abstract class AbstractContentProducer
implements ContentProducer {
    protected static final int DEFAULT_LENGTH = 5;
    private static final Random RAND = new Random();
    private final int length;
    private final char[] srcChars;

    public AbstractContentProducer(int length, char[] srcChars) {
        if (length <= 0) {
            throw new IllegalArgumentException("Content length must be positive.");
        }
        this.length = length;
        this.srcChars = Arrays.copyOf(srcChars, srcChars.length);
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.srcChars[RAND.nextInt(this.srcChars.length)]);
        }
        return sb.toString();
    }
}

