/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.filter;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import net.logicsquad.nanocaptcha.image.filter.ImageFilter;

public class StretchImageFilter
implements ImageFilter {
    private static final double XDEFAULT = 1.0;
    private static final double YDEFAULT = 3.0;
    private final double xScale;
    private final double yScale;

    public StretchImageFilter() {
        this(1.0, 3.0);
    }

    public StretchImageFilter(double xScale, double yScale) {
        this.xScale = xScale;
        this.yScale = yScale;
    }

    @Override
    public void filter(BufferedImage image) {
        Graphics2D g = image.createGraphics();
        AffineTransform at = new AffineTransform();
        at.scale(this.xScale, this.yScale);
        g.drawRenderedImage(image, at);
    }
}

