/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.backgrounds;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import net.logicsquad.nanocaptcha.image.backgrounds.BackgroundProducer;

public class SquigglesBackgroundProducer
implements BackgroundProducer {
    @Override
    public BufferedImage getBackground(int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics2D graphics = result.createGraphics();
        BasicStroke bs = new BasicStroke(2.0f, 0, 0, 2.0f, new float[]{2.0f, 2.0f}, 0.0f);
        graphics.setStroke(bs);
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.75f);
        graphics.setComposite(ac);
        graphics.translate((double)width * -1.0, 0.0);
        double delta = 5.0;
        for (double xt = 0.0; xt < 2.0 * (double)width; xt += delta) {
            Arc2D.Double arc = new Arc2D.Double(0.0, 0.0, width, height, 0.0, 360.0, 0);
            graphics.draw(arc);
            graphics.translate(delta, 0.0);
        }
        graphics.dispose();
        return result;
    }
}

