/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.audio.noise;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.logicsquad.nanocaptcha.audio.Mixer;
import net.logicsquad.nanocaptcha.audio.Sample;
import net.logicsquad.nanocaptcha.audio.noise.NoiseProducer;

public class RandomNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new SecureRandom();
    private static final String[] BUILT_IN_NOISES = new String[]{"/sounds/noises/radio_tuning.wav", "/sounds/noises/restaurant.wav", "/sounds/noises/swimming.wav"};
    private final String[] noiseFiles;

    public RandomNoiseProducer() {
        this(BUILT_IN_NOISES);
    }

    public RandomNoiseProducer(String[] noiseFiles) {
        this.noiseFiles = noiseFiles;
    }

    @Override
    public Sample addNoise(List<Sample> samples) {
        Sample appended = Mixer.concatenate(samples);
        String noiseFile = this.noiseFiles[RAND.nextInt(this.noiseFiles.length)];
        Sample noise = new Sample(noiseFile);
        return Mixer.mix(appended, 1.0, noise, 0.6);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RandomNoiseProducer: noiseFiles=");
        sb.append(Arrays.asList(this.noiseFiles).stream().collect(Collectors.joining(",")));
        sb.append("]");
        return sb.toString();
    }
}

